/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.example;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.wicketstuff.shiro.annotation.AnnotationsShiroAuthorizationStrategy;
import org.wicketstuff.shiro.authz.ShiroUnauthorizedComponentListener;
import org.wicketstuff.shiro.example.pages.IndexPage;
import org.wicketstuff.shiro.example.pages.LoginPage;
import org.wicketstuff.shiro.example.pages.RequireAdminRolePage;
import org.wicketstuff.shiro.example.pages.RequireAuthPage;
import org.wicketstuff.shiro.example.pages.RequireViewPermissionPage;
import org.wicketstuff.shiro.example.pages.UnauthorizedPage;
import org.wicketstuff.shiro.page.LogoutPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExampleApplication
extends WebApplication {
    protected void init() {
        this.getMarkupSettings().setStripWicketTags(true);
        AnnotationsShiroAuthorizationStrategy authz = new AnnotationsShiroAuthorizationStrategy();
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)authz);
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)new ShiroUnauthorizedComponentListener(LoginPage.class, UnauthorizedPage.class, authz));
        this.mountBookmarkablePage("account/login", LoginPage.class);
        this.mountBookmarkablePage("account/logout", LogoutPage.class);
        this.mountBookmarkablePage("admin", RequireAdminRolePage.class);
        this.mountBookmarkablePage("view", RequireViewPermissionPage.class);
        this.mountBookmarkablePage("auth", RequireAuthPage.class);
    }

    public abstract Component getExampleInfoPanel(String var1);

    public abstract Component getAuthHeaderPanel(String var1);

    public Class<? extends Page> getHomePage() {
        return IndexPage.class;
    }
}

