/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.example.realm;

import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SillyRealm
extends AuthorizingRealm {
    static final Logger log = LoggerFactory.getLogger(SillyRealm.class);

    public SillyRealm() {
        log.info("constructor...");
        this.setCacheManager((CacheManager)new MemoryConstrainedCacheManager());
    }

    protected SimpleAccount getAccount(String username) {
        log.info("get account: " + username);
        SimpleAccount account = new SimpleAccount((Object)username, (Object)"pass", this.getName());
        account.addRole("user");
        if ("admin".equals(username)) {
            account.addRole("admin");
        }
        account.addStringPermission("blogEntry:edit");
        account.addStringPermission("printer:print:laserjet2000");
        account.addStringPermission("view");
        return account;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        log.info("doGetAuthenticationInfo: " + token);
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        return this.getAccount(upToken.getUsername());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        log.info("doGetAuthorizationInfo: " + principals);
        Collection thisRealmPrincipals = principals.fromRealm(this.getName());
        if (thisRealmPrincipals == null || thisRealmPrincipals.isEmpty()) {
            return null;
        }
        String username = (String)thisRealmPrincipals.iterator().next();
        return this.getAccount(username);
    }
}

