/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.shiro.example.jdbc;

import javax.sql.DataSource;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;

public class BootstrapDataPopulator
implements InitializingBean {
    private static final String CREATE_TABLES = "create table users (\n    username varchar(255) primary key,\n    password varchar(255) not null\n);\n\ncreate table roles (\n    role_name varchar(255) primary key\n);\n\ncreate table user_roles (\n    username varchar(255) not null,\n    role_name varchar(255) not null,\n    constraint user_roles_uq unique ( username, role_name )\n);\n\ncreate table roles_permissions (\n    role_name varchar(255) not null,\n    permission varchar(255) not null,\n    primary key (role_name, permission)\n);";
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapDataPopulator.class);
    protected DataSource dataSource = null;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.execute(CREATE_TABLES);
        String query = "insert into users values ('user', '" + new Sha256Hash((Object)"user").toBase64() + "' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created user.");
        query = "insert into users values ( 'admin', '" + new Sha256Hash((Object)"admin").toBase64() + "' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created admin.");
        query = "insert into roles values ( 'user' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created user");
        query = "insert into roles values ( 'admin' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created admin");
        query = "insert into roles_permissions values ( 'user', 'view')";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created permission view for role user");
        query = "insert into roles_permissions values ( 'admin', 'user:*')";
        jdbcTemplate.execute(query);
        LOGGER.debug("Created permission user:* for role admin");
        query = "insert into user_roles values ( 'user', 'user' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Assigned user role user");
        query = "insert into user_roles values ( 'admin', 'admin' )";
        jdbcTemplate.execute(query);
        LOGGER.debug("Assigned admin role admin");
    }
}

