/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.closurecompiler;

import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.closurecompiler.ClosureCompilationException;

public class ClosureCompilerJavaScriptCompressor
implements IJavaScriptCompressor {
    private static final Logger log = LoggerFactory.getLogger(ClosureCompilerJavaScriptCompressor.class);
    private CompilationLevel level = CompilationLevel.SIMPLE_OPTIMIZATIONS;

    public CompilationLevel getLevel() {
        return this.level;
    }

    public void setLevel(CompilationLevel level) {
        this.level = (CompilationLevel)Args.notNull((Object)level, (String)"level");
    }

    public String compress(String uncompressed) {
        try {
            return this.compressSource(uncompressed);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return uncompressed;
        }
    }

    public final String compressSource(String uncompressed) throws Exception {
        List externs = CommandLineRunner.getDefaultExterns();
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        this.level.setOptionsForCompilationLevel(options);
        options.removeUnusedVars = false;
        options.removeUnusedLocalVars = false;
        options.removeUnusedPrototypeProperties = false;
        options.removeUnusedPrototypePropertiesInExterns = false;
        this.configure(compiler, options, externs);
        ArrayList<JSSourceFile> inputs = new ArrayList<JSSourceFile>();
        inputs.add(JSSourceFile.fromCode((String)"custom", (String)uncompressed));
        Result result = compiler.compile(externs, inputs, options);
        if (!result.success) {
            throw new ClosureCompilationException(Arrays.asList(result.errors));
        }
        return compiler.toSource();
    }

    protected void configure(Compiler compiler, CompilerOptions options, List<SourceFile> externs) {
    }
}

