/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.console.templates;

import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.console.engine.Lang;
import org.wicketstuff.console.templates.IScriptTemplateStore;
import org.wicketstuff.console.templates.ReadOnlyStoreException;
import org.wicketstuff.console.templates.ScriptTemplate;
import org.wicketstuff.console.templates.ScriptTemplateUtils;
import scala.actors.threadpool.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagedScriptTemplates
implements IScriptTemplateStore {
    private static final long serialVersionUID = 1L;
    private static final String SCRIPT_DIR_BASE = "org/wicketstuff/console/templates/";
    private static final String[] PACKAGED_GROOVY_TEMPLATES = new String[]{"ScriptStoreList", "ScriptStoreSave", "ScriptStoreDelete", "ScriptStoreGet", "HibernateCriteria", "HibernateHqlQuery", "HibernateSave", "HibernateShowSql", "HibernateStatistics", "Hibernate2ndLevelCache", "Log4j", "MethodsAndFields", "ReadClasspathResource", "SystemProperties", "WicketClearMarkupCache", "WicketClearPropertiesCache", "WicketClientInfo", "WicketComponentHierarchy", "WicketInvalidateSession", "WicketSize"};
    private static final String[] PACKAGED_CLOJURE_TEMPLATES = new String[]{"HibernateSave", "HibernateCriteria", "HibernateHqlQuery", "HibernateShowSql", "HibernateStatistics", "Log4j", "MethodsAndFields", "ReadClasspathResource", "SystemProperties", "WicketClearMarkupCache", "WicketClearPropertiesCache", "WicketClientInfo", "WicketComponentHierarchy", "WicketInvalidateSession", "WicketSize"};
    private static final String[] PACKAGED_SCALA_TEMPLATES = new String[]{"HibernateCriteria"};
    private static final String[] PACKAGED_JYTHON_TEMPLATES = new String[]{"HibernateSave", "HibernateCriteria", "HibernateHqlQuery", "HibernateShowSql", "Log4j", "MethodsAndFields", "SystemProperties", "WicketClearMarkupCache", "WicketClearPropertiesCache", "WicketClientInfo", "WicketInvalidateSession", "WicketSize"};

    @Override
    public List<ScriptTemplate> findAll(Lang lang) {
        String[] templateNames;
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (String name : templateNames = this.templateNamesForLang(lang)) {
            ScriptTemplate template = this.getTemplate(lang, name);
            templates.add(template);
        }
        return templates;
    }

    private String[] templateNamesForLang(Lang lang) {
        String[] templateNames = new String[]{};
        switch (lang) {
            case GROOVY: {
                templateNames = PACKAGED_GROOVY_TEMPLATES;
                break;
            }
            case CLOJURE: {
                templateNames = PACKAGED_CLOJURE_TEMPLATES;
                break;
            }
            case SCALA: {
                templateNames = PACKAGED_SCALA_TEMPLATES;
                break;
            }
            case JYTHON: {
                templateNames = PACKAGED_JYTHON_TEMPLATES;
                break;
            }
        }
        return templateNames;
    }

    @Override
    public ScriptTemplate getById(Long id) {
        return this.templateForId(id);
    }

    private ScriptTemplate getTemplate(Lang lang, String name) {
        ClassLoader cl = PackagedScriptTemplates.class.getClassLoader();
        String scriptBase = SCRIPT_DIR_BASE + lang.name().toLowerCase() + "/";
        ScriptTemplate template = ScriptTemplateUtils.readTemplateFromClasspath(cl, scriptBase, name, lang);
        template.id = this.idForTemplate(lang, name);
        return template;
    }

    private ScriptTemplate templateForId(Long id) {
        Lang lang = Lang.values()[(int)(id / 1000L)];
        String name = this.templateNamesForLang(lang)[(int)(id % 1000L)];
        return this.getTemplate(lang, name);
    }

    private Long idForTemplate(Lang lang, String name) {
        int major = lang.ordinal() * 1000;
        int minor = Arrays.asList((Object[])this.templateNamesForLang(lang)).indexOf(name);
        return major + minor;
    }

    @Override
    public boolean readOnly() {
        return true;
    }

    @Override
    public void save(ScriptTemplate t) throws ReadOnlyStoreException {
        throw new ReadOnlyStoreException("This is an internal read-only store");
    }

    @Override
    public void delete(ScriptTemplate template) throws ReadOnlyStoreException {
        throw new ReadOnlyStoreException("This is an internal read-only store");
    }

    @Override
    public void delete(Long id) throws ReadOnlyStoreException {
        throw new ReadOnlyStoreException("This is an internal read-only store");
    }

    public void detach() {
    }
}

