/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.console.templates;

import java.util.Iterator;
import java.util.List;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.wicketstuff.console.engine.Lang;
import org.wicketstuff.console.templates.IScriptTemplateStore;
import org.wicketstuff.console.templates.ScriptTemplate;
import org.wicketstuff.console.templates.StoredScriptTemplateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTemplateStoreDataProvider
implements IDataProvider<ScriptTemplate> {
    private static final long serialVersionUID = 1L;
    private final IScriptTemplateStore store;
    private final Lang lang;
    private List<ScriptTemplate> allTemplates;

    public ScriptTemplateStoreDataProvider(IScriptTemplateStore store, Lang lang) {
        this.store = store;
        this.lang = lang;
    }

    public Iterator<? extends ScriptTemplate> iterator(int first, int count) {
        this.init();
        return this.allTemplates.subList(first, first + count).iterator();
    }

    public int size() {
        this.init();
        return this.allTemplates.size();
    }

    private void init() {
        if (this.allTemplates == null) {
            this.allTemplates = this.store.findAll(this.lang);
        }
    }

    public IModel<ScriptTemplate> model(ScriptTemplate template) {
        return new StoredScriptTemplateModel(this.store, template);
    }

    public void detach() {
        this.allTemplates = null;
    }
}

