/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.console.templates;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.io.IOUtils;
import org.wicketstuff.console.engine.Lang;
import org.wicketstuff.console.engine.LangFileFilter;
import org.wicketstuff.console.templates.ScriptTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTemplateUtils {
    static ScriptTemplate readTemplateFromClasspath(ClassLoader cl, String path, String name, Lang lang) {
        StringBuilder content;
        String resourceName = path + name + lang.getFileExtension();
        URL url = cl.getResource(resourceName);
        if (url == null) {
            throw new RuntimeException("Classpath URL for " + resourceName + " not found");
        }
        try {
            content = ScriptTemplateUtils.readUrl(url);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not read class path file %s %s %s", path, name, lang));
        }
        ScriptTemplate template = new ScriptTemplate(ScriptTemplateUtils.camelCaseSpace(name), content.toString(), lang);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder readUrl(URL url) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StringBuilder content = new StringBuilder();
            String line = null;
            while ((line = r.readLine()) != null) {
                content.append(line).append("\n");
            }
            StringBuilder stringBuilder = content;
            return stringBuilder;
        }
        finally {
            r.close();
        }
    }

    public static List<ScriptTemplate> readTemplatesFromDir(Lang lang, File dir) {
        File[] files;
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (File file : files = dir.listFiles((FilenameFilter)LangFileFilter.create((Lang)lang))) {
            ScriptTemplate template = ScriptTemplateUtils.readTemplateFromFile(lang, file);
            templates.add(template);
        }
        return templates;
    }

    public static ScriptTemplate readTemplateFromFile(Lang lang, File file) {
        String title = ScriptTemplateUtils.camelCaseSpaceFilename(file);
        String script = ScriptTemplateUtils.readFile(file);
        ScriptTemplate template = new ScriptTemplate(title, script, lang);
        return template;
    }

    public static String camelCaseSpaceFilename(File file) {
        String filename = file.getName();
        return ScriptTemplateUtils.camelCaseSpaceFilename(filename);
    }

    public static String camelCaseSpaceFilename(String filename) {
        int indexOfExt = filename.lastIndexOf(46);
        if (indexOfExt == 0) {
            throw new RuntimeException("Invalid filename " + filename);
        }
        String baseFilename = filename.substring(0, indexOfExt);
        String scriptName = ScriptTemplateUtils.camelCaseSpace(baseFilename);
        return scriptName;
    }

    public static String camelCaseSpace(String str) {
        if (str.length() == 0) {
            throw new RuntimeException("camelCaseSpace not allowed for string length 0");
        }
        char[] charArray = str.toCharArray();
        StringBuilder result = new StringBuilder(charArray[0] + "");
        for (int i = 1; i < charArray.length; ++i) {
            char c = charArray[i];
            if (Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(File file) {
        String string;
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
        try {
            string = IOUtils.toString((InputStream)bin);
        }
        catch (Throwable throwable) {
            try {
                bin.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read file " + file, e);
            }
        }
        bin.close();
        return string;
    }
}

