/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.cassandra.ICassandraSettings;

public class CassandraDataStore
implements IDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataStore.class);
    private static final String COLUMN_SESSION_ID = "sessionId";
    private static final String COLUMN_PAGE_ID = "pageId";
    private static final String COLUMN_DATA = "data";
    private final Cluster cluster;
    private final Session session;
    private final ICassandraSettings settings;

    public CassandraDataStore(ICassandraSettings settings) {
        this(CassandraDataStore.createCluster(settings), settings);
    }

    private static Cluster createCluster(ICassandraSettings settings) {
        Args.notNull((Object)settings, (String)"settings");
        List<String> contactPoints = settings.getContactPoints();
        if (contactPoints == null || contactPoints.size() == 0) {
            throw new IllegalArgumentException("At least one contact point must be providedto be able to connect to Cassandra. See ICassandraSettings#getContactPoints.");
        }
        String[] contactPointsAsArray = contactPoints.toArray(new String[contactPoints.size()]);
        Cluster cluster = Cluster.builder().addContactPoints(contactPointsAsArray).build();
        return cluster;
    }

    public CassandraDataStore(Cluster cluster, ICassandraSettings settings) {
        this.cluster = (Cluster)Args.notNull((Object)cluster, (String)"cluster");
        this.settings = (ICassandraSettings)Args.notNull((Object)settings, (String)"settings");
        Metadata metadata = cluster.getMetadata();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connected to cluster: {}", (Object)metadata.getClusterName());
            for (Host host : metadata.getAllHosts()) {
                LOGGER.info("Datatacenter: {}; Host: {}; Rack: {}", new Object[]{host.getDatacenter(), host.getAddress(), host.getRack()});
            }
        }
        this.session = cluster.connect();
        String keyspaceName = settings.getKeyspaceName();
        KeyspaceMetadata keyspaceMetadata = this.createKeyspaceIfNecessary(keyspaceName, metadata);
        this.createTableIfNecessary(keyspaceName, keyspaceMetadata);
        LOGGER.info("Data will be stored in table '{}' in keyspace '{}'.", (Object)settings.getTableName(), (Object)keyspaceName);
    }

    public byte[] getData(String sessionId, int pageId) {
        Select.Where dataSelect = QueryBuilder.select((String[])new String[]{COLUMN_DATA}).from(this.settings.getKeyspaceName(), this.settings.getTableName()).where(QueryBuilder.eq((String)COLUMN_SESSION_ID, (Object)sessionId)).and(QueryBuilder.eq((String)COLUMN_PAGE_ID, (Object)pageId));
        ResultSet rows = this.session.execute((Statement)dataSelect);
        Row row = rows.one();
        byte[] bytes = null;
        if (row != null) {
            ByteBuffer data = row.getBytes(COLUMN_DATA);
            bytes = new byte[data.remaining()];
            data.get(bytes);
            LOGGER.debug("Got data for session '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
        }
        return bytes;
    }

    public void removeData(String sessionId, int pageId) {
        Delete.Where delete = QueryBuilder.delete().all().from(this.settings.getKeyspaceName(), this.settings.getTableName()).where(QueryBuilder.eq((String)COLUMN_SESSION_ID, (Object)sessionId)).and(QueryBuilder.eq((String)COLUMN_PAGE_ID, (Object)pageId));
        this.session.execute((Statement)delete);
        LOGGER.debug("Deleted data for session '{}' and page with id '{}'", (Object)sessionId, (Object)pageId);
    }

    public void removeData(String sessionId) {
        Delete.Where delete = QueryBuilder.delete().all().from(this.settings.getKeyspaceName(), this.settings.getTableName()).where(QueryBuilder.eq((String)COLUMN_SESSION_ID, (Object)sessionId));
        this.session.execute((Statement)delete);
        LOGGER.debug("Deleted data for session '{}'", (Object)sessionId);
    }

    public void storeData(String sessionId, int pageId, byte[] data) {
        Insert insert = QueryBuilder.insertInto((String)this.settings.getKeyspaceName(), (String)this.settings.getTableName()).using(QueryBuilder.ttl((int)((int)this.settings.getRecordTtl().minutes()))).values(new String[]{COLUMN_SESSION_ID, COLUMN_PAGE_ID, COLUMN_DATA}, new Object[]{sessionId, pageId, ByteBuffer.wrap(data)});
        this.session.execute((Statement)insert);
        LOGGER.debug("Inserted data for session '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
    }

    public void destroy() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public boolean isReplicated() {
        return true;
    }

    public boolean canBeAsynchronous() {
        return true;
    }

    protected void createTableIfNecessary(String keyspaceName, KeyspaceMetadata keyspaceMetadata) {
        TableMetadata tableMetadata;
        String tableName = this.settings.getTableName();
        TableMetadata tableMetadata2 = tableMetadata = keyspaceMetadata != null ? keyspaceMetadata.getTable(tableName) : null;
        if (tableMetadata == null) {
            this.session.execute(String.format("CREATE TABLE %s.%s (%s varchar,%s int,%s blob,PRIMARY KEY (%s, %s));", keyspaceName, tableName, COLUMN_SESSION_ID, COLUMN_PAGE_ID, COLUMN_DATA, COLUMN_SESSION_ID, COLUMN_PAGE_ID));
            LOGGER.debug("Created table with name {}.{}", (Object)keyspaceName, (Object)tableName);
        }
    }

    protected KeyspaceMetadata createKeyspaceIfNecessary(String keyspaceName, Metadata metadata) {
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(keyspaceName);
        if (keyspaceMetadata == null) {
            this.session.execute(String.format("CREATE KEYSPACE %s WITH replication = {'class':'SimpleStrategy', 'replication_factor':3};", keyspaceName));
            LOGGER.debug("Created keyspace with name {}", (Object)keyspaceName);
        }
        return keyspaceMetadata;
    }
}

