/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.wicketstuff.datastores.common.PageData;
import org.wicketstuff.datastores.common.SessionData;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;

public class SessionQuotaManagingDataStoreTest
extends Assert {
    private final IDataStore delegate = new NoopDataStore();
    private final String sessionId = "abcd";
    private final String sessionId2 = "efgh";
    private final int pageId1 = 1;
    private final byte[] pageData1 = new byte[]{1, 2, 3, 4};
    private final int pageId2 = 2;
    private final byte[] pageData2 = new byte[]{5, 6, 7};

    @Test
    public void removeData() throws Exception {
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, Bytes.bytes((long)100L));
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.removeData("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        manager.storeData("efgh", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)manager.pagesPerSession.size());
        manager.removeData("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        manager.removeData("efgh");
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
    }

    @Test
    public void storeDataEnoughSpace() throws Exception {
        Bytes maxSizePerSession = Bytes.bytes((long)(this.pageData1.length + this.pageData2.length + 1));
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        manager.storeData("efgh", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)manager.pagesPerSession.size());
        SessionData sessionData = (SessionData)manager.pagesPerSession.get("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        manager.storeData("abcd", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)sessionData.pages.size());
    }

    @Test
    public void storeDataInsufficientSpaceForTwoPages() throws Exception {
        Bytes maxSizePerSession = Bytes.bytes((long)this.pageData1.length);
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionData sessionData = (SessionData)manager.pagesPerSession.get("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)((PageData)sessionData.pages.element()).pageId);
        manager.storeData("abcd", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)((PageData)sessionData.pages.element()).pageId);
    }

    @Test
    public void storeDataInsufficientSpaceForASinglePage() throws Exception {
        Bytes maxSizePerSession = Bytes.bytes((long)(this.pageData1.length - 1));
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionData sessionData = (SessionData)manager.pagesPerSession.get("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)((PageData)sessionData.pages.element()).pageId);
        manager.storeData("abcd", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)((PageData)sessionData.pages.element()).pageId);
    }

    @Test
    public void storeDataSamePageTwice() throws Exception {
        byte[] pageData1_2 = new byte[]{1};
        Bytes maxSizePerSession = Bytes.bytes((long)(this.pageData1.length + pageData1_2.length + 1));
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionData sessionData = (SessionData)manager.pagesPerSession.get("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)((PageData)sessionData.pages.element()).pageId);
        SessionQuotaManagingDataStoreTest.assertEquals((long)this.pageData1.length, (long)sessionData.size);
        manager.storeData("abcd", 1, pageData1_2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)((PageData)sessionData.pages.element()).pageId);
        SessionQuotaManagingDataStoreTest.assertEquals((long)pageData1_2.length, (long)sessionData.size);
    }

    @Test
    public void removePage() throws Exception {
        Bytes maxSizePerSession = Bytes.bytes((long)(this.pageData1.length + this.pageData2.length + 1));
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionData sessionData = (SessionData)manager.pagesPerSession.get("abcd");
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)this.pageData1.length, (long)sessionData.size);
        manager.storeData("abcd", 2, this.pageData2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)2L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)(this.pageData1.length + this.pageData2.length), (long)sessionData.size);
        manager.removeData("abcd", 1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)sessionData.pages.size());
        SessionQuotaManagingDataStoreTest.assertEquals((long)this.pageData2.length, (long)sessionData.size);
        manager.removeData("abcd", 2);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
    }

    @Test
    public void destroy() throws Exception {
        Bytes maxSizePerSession = Bytes.bytes((long)(this.pageData1.length + 1));
        SessionQuotaManagingDataStore manager = new SessionQuotaManagingDataStore(this.delegate, maxSizePerSession);
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
        manager.storeData("abcd", 1, this.pageData1);
        SessionQuotaManagingDataStoreTest.assertEquals((long)1L, (long)manager.pagesPerSession.size());
        manager.destroy();
        SessionQuotaManagingDataStoreTest.assertEquals((long)0L, (long)manager.pagesPerSession.size());
    }

    private static class NoopDataStore
    implements IDataStore {
        private NoopDataStore() {
        }

        public byte[] getData(String sessionId, int id) {
            return new byte[0];
        }

        public void removeData(String sessionId, int id) {
        }

        public void removeData(String sessionId) {
        }

        public void storeData(String sessionId, int id, byte[] data) {
        }

        public void destroy() {
        }

        public boolean isReplicated() {
            return false;
        }

        public boolean canBeAsynchronous() {
            return false;
        }
    }
}

