/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.wicketstuff.datastores.common.PageData;

class SessionData {
    private final String sessionId;
    final ConcurrentLinkedQueue<PageData> pages;
    long size;

    SessionData(String sessionId) {
        this.sessionId = (String)Args.notNull((Object)sessionId, (String)"sessionId");
        this.pages = new ConcurrentLinkedQueue();
    }

    synchronized void addPage(PageData page) {
        Args.notNull((Object)page, (String)"page");
        this.removePage(page.pageId);
        this.pages.add(page);
        this.size += (long)page.size;
    }

    private PageData removePage() {
        if (this.pages.isEmpty()) {
            throw new IllegalStateException(String.format("There are no used pages in session '%s'", this.sessionId));
        }
        PageData page = this.pages.poll();
        this.size -= (long)page.size;
        return page;
    }

    synchronized void removePage(int pageId) {
        Iterator<PageData> pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            PageData page = pageIterator.next();
            if (page.pageId != pageId) continue;
            pageIterator.remove();
            this.size -= (long)page.size;
            break;
        }
    }

    synchronized Integer removePageIfQuotaExceeded(int pageSize, Bytes maxSizePerSession) {
        Integer removedPageId = null;
        if (this.size > 0L && !maxSizePerSession.greaterThan(this.size + (long)pageSize)) {
            PageData removedPage = this.removePage();
            removedPageId = removedPage.pageId;
        }
        return removedPageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionData that = (SessionData)o;
        return this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }
}

