/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.common.PageData;
import org.wicketstuff.datastores.common.SessionData;

public class SessionQuotaManagingDataStore
implements IDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(SessionQuotaManagingDataStore.class);
    final ConcurrentMap<String, SessionData> pagesPerSession = new ConcurrentHashMap<String, SessionData>();
    private final Bytes maxSizePerSession;
    private final IDataStore delegate;

    public SessionQuotaManagingDataStore(IDataStore delegate, Bytes maxSizePerSession) {
        this.delegate = (IDataStore)Args.notNull((Object)delegate, (String)"delegate");
        this.maxSizePerSession = (Bytes)Args.notNull((Object)maxSizePerSession, (String)"maxSizePerSession");
    }

    public byte[] getData(String sessionId, int pageId) {
        return this.delegate.getData(sessionId, pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String sessionId) {
        SessionData sessionData = (SessionData)this.pagesPerSession.get(sessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                this.delegate.removeData(sessionId);
                this.pagesPerSession.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeData(String sessionId, int pageId, byte[] data) {
        Integer removedPageId;
        SessionData old;
        SessionData sessionData = (SessionData)this.pagesPerSession.get(sessionId);
        if (sessionData == null && (old = this.pagesPerSession.putIfAbsent(sessionId, sessionData = new SessionData(sessionId))) != null) {
            sessionData = old;
        }
        int pageSize = data.length;
        while ((removedPageId = sessionData.removePageIfQuotaExceeded(pageSize, this.maxSizePerSession)) != null) {
            LOG.debug("Removing page '{}' from session '{}' because the quota is reached.", (Object)removedPageId, (Object)sessionId);
            this.delegate.removeData(sessionId, removedPageId.intValue());
        }
        SessionData sessionData2 = sessionData;
        synchronized (sessionData2) {
            this.delegate.storeData(sessionId, pageId, data);
            PageData page = new PageData(pageId, pageSize);
            sessionData.addPage(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String sessionId, int pageId) {
        SessionData sessionData = (SessionData)this.pagesPerSession.get(sessionId);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                this.delegate.removeData(sessionId, pageId);
                sessionData.removePage(pageId);
                if (sessionData.pages.isEmpty()) {
                    this.pagesPerSession.remove(sessionId);
                }
            }
        }
    }

    public void destroy() {
        this.pagesPerSession.clear();
        this.delegate.destroy();
    }

    public boolean isReplicated() {
        return this.delegate.isReplicated();
    }

    public boolean canBeAsynchronous() {
        return this.delegate.canBeAsynchronous();
    }
}

