/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.ignite;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteDataStore
implements IDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(IgniteDataStore.class);
    private final Ignite ignite;

    public IgniteDataStore(Ignite ignite) {
        this.ignite = (Ignite)Args.notNull((Object)ignite, (String)"ignite");
    }

    private IgniteCache<Integer, byte[]> getIgniteCache(String cacheName) {
        return this.ignite.getOrCreateCache(cacheName);
    }

    public byte[] getData(String sessionId, int pageId) {
        byte[] bytes = null;
        IgniteCache<Integer, byte[]> cache = this.getIgniteCache(sessionId);
        if (cache != null) {
            bytes = (byte[])cache.get((Object)pageId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{bytes != null ? "data" : "'null'", sessionId, pageId});
        }
        return bytes;
    }

    public void removeData(String sessionId, int pageId) {
        IgniteCache<Integer, byte[]> cache = this.getIgniteCache(sessionId);
        if (cache != null && cache.remove((Object)pageId) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted data for session '{}' and page with id '{}'", (Object)sessionId, (Object)pageId);
        }
    }

    public void removeData(String sessionId) {
        IgniteCache<Integer, byte[]> cache = this.getIgniteCache(sessionId);
        if (cache != null) {
            cache.destroy();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleted data for session '{}'", (Object)sessionId);
            }
        }
    }

    public void storeData(String sessionId, int pageId, byte[] data) {
        IgniteCache<Integer, byte[]> cache = this.getIgniteCache(sessionId);
        if (cache != null) {
            cache.put((Object)pageId, (Object)data);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Inserted data for session '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
            }
        }
    }

    public void destroy() {
        if (this.ignite != null) {
            try {
                this.ignite.close();
            }
            catch (IgniteException e) {
                LOGGER.error("Can't close ignite instance", (Throwable)e);
            }
        }
    }

    public boolean isReplicated() {
        return true;
    }

    public boolean canBeAsynchronous() {
        return true;
    }
}

