/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.ignite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteDataStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(IgniteDataStore.class);
    private final Ignite ignite;

    public IgniteDataStore(String applicatioName, Ignite ignite) {
        super(applicatioName);
        this.ignite = (Ignite)Args.notNull((Object)ignite, (String)"ignite");
    }

    private IgniteCache<Integer, BinarylizableWrapper> getIgniteCache(String cacheName, boolean create) {
        if (create) {
            return this.ignite.getOrCreateCache(cacheName);
        }
        return this.ignite.cache(cacheName);
    }

    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        IgniteCache<Integer, BinarylizableWrapper> cache = this.getIgniteCache(sessionIdentifier, false);
        if (cache != null) {
            BinarylizableWrapper wrapper = (BinarylizableWrapper)cache.get((Object)id);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{wrapper, sessionIdentifier, id});
            }
            if (wrapper != null) {
                return wrapper.page;
            }
        }
        return null;
    }

    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        IgniteCache<Integer, BinarylizableWrapper> cache = this.getIgniteCache(sessionIdentifier, false);
        if (cache != null) {
            cache.remove((Object)page.getPageId());
            LOGGER.debug("Deleted page for session '{}' and page with id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
        }
    }

    protected void removeAllPersistedPages(String sessionIdentifier) {
        IgniteCache<Integer, BinarylizableWrapper> cache = this.getIgniteCache(sessionIdentifier, false);
        if (cache != null) {
            cache.clear();
            LOGGER.debug("Deleted page for session '{}'", (Object)sessionIdentifier);
        }
    }

    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("IgniteDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        IgniteCache<Integer, BinarylizableWrapper> cache = this.getIgniteCache(sessionIdentifier, true);
        cache.put((Object)page.getPageId(), (Object)new BinarylizableWrapper(serializedPage));
        LOGGER.debug("Inserted page for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    public void destroy() {
        if (this.ignite != null) {
            try {
                this.ignite.close();
            }
            catch (IgniteException e) {
                LOGGER.error("Can't close ignite instance", (Throwable)e);
            }
        }
    }

    public boolean supportsVersioning() {
        return true;
    }

    public Set<String> getSessionIdentifiers() {
        return new HashSet<String>(this.ignite.cacheNames());
    }

    public List<IPersistedPage> getPersistedPages(String contextIdentifier) {
        ArrayList<IPersistedPage> pages = new ArrayList<IPersistedPage>();
        IgniteCache<Integer, BinarylizableWrapper> cache = this.getIgniteCache(contextIdentifier, false);
        if (cache != null) {
            cache.forEach(entry -> {
                SerializedPage serializedPage = ((BinarylizableWrapper)entry.getValue()).page;
                pages.add((IPersistedPage)new AbstractPersistentPageStore.PersistedPage(serializedPage.getPageId(), serializedPage.getPageType(), (long)serializedPage.getData().length));
            });
        }
        return pages;
    }

    public Bytes getTotalSize() {
        long bytes = 0L;
        for (DataRegionMetrics metrics : this.ignite.dataRegionMetrics()) {
            bytes += metrics.getTotalAllocatedSize();
        }
        return Bytes.bytes((long)bytes);
    }

    private static final class BinarylizableWrapper
    implements Binarylizable {
        private static final String DATA = "data";
        private static final String TYPE = "type";
        private static final String ID = "id";
        public SerializedPage page;

        public BinarylizableWrapper(SerializedPage page) {
            this.page = page;
        }

        public String toString() {
            return this.page.toString();
        }

        public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
            writer.writeInt(ID, this.page.getPageId());
            writer.writeString(TYPE, this.page.getPageType());
            writer.writeByteArray(DATA, this.page.getData());
        }

        public void readBinary(BinaryReader reader) throws BinaryObjectException {
            this.page = new SerializedPage(reader.readInt(ID), reader.readString(TYPE), reader.readByteArray(DATA));
        }
    }
}

