/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.MemcachedClient;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.memcached.IMemcachedSettings;
import org.wicketstuff.datastores.memcached.MemcachedSet;

public class MemcachedDataStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemcachedDataStore.class);
    private static final String KEY_SUFFIX = "Wicket-Memcached";
    private static final String SEPARATOR = "|||";
    private static final String SESSIONS = "sessions";
    private static final String SESSION_PAGES = "pages";
    private static final String PAGE_TYPE = "type";
    private static final String PAGE_SIZE = "size";
    private static final String PAGE_DATA = "data";
    private final MemcachedClient client;
    private final IMemcachedSettings settings;

    public MemcachedDataStore(String applicationName, IMemcachedSettings settings) throws IOException {
        this(applicationName, MemcachedDataStore.createClient(settings), settings);
    }

    public MemcachedDataStore(String applicationName, MemcachedClient client, IMemcachedSettings settings) {
        super(applicationName);
        this.client = (MemcachedClient)Args.notNull((Object)client, (String)"client");
        this.settings = (IMemcachedSettings)Args.notNull((Object)settings, (String)"settings");
        client.addObserver(new ConnectionObserver(){

            public void connectionEstablished(SocketAddress sa, int reconnectCount) {
                LOG.info("Established connection to: {}, reconnect count: {}", (Object)sa, (Object)reconnectCount);
            }

            public void connectionLost(SocketAddress sa) {
                LOG.warn("Lost connection to: {}", (Object)sa);
            }
        });
    }

    public static MemcachedClient createClient(IMemcachedSettings settings) throws IOException {
        Args.notNull((Object)settings, (String)"settings");
        int port = settings.getPort();
        Checks.withinRangeShort((Comparable)Integer.valueOf(10000), (Comparable)Integer.valueOf(65535), (Comparable)Integer.valueOf(port), (String)"port");
        List<String> hostnames = settings.getServerList();
        InetSocketAddress[] addresses = new InetSocketAddress[hostnames.size()];
        for (int i = 0; i < hostnames.size(); ++i) {
            String hostname = hostnames.get(i);
            addresses[i] = new InetSocketAddress(hostname, port);
        }
        return new MemcachedClient(addresses);
    }

    public boolean supportsVersioning() {
        return true;
    }

    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        byte[] data = (byte[])this.client.get(this.makeKey(sessionIdentifier, id, PAGE_DATA));
        if (data != null) {
            String type = (String)this.client.get(this.makeKey(sessionIdentifier, id, PAGE_TYPE));
            LOG.debug("Got page for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)id);
            return new SerializedPage(id, type, data);
        }
        return null;
    }

    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        new MemcachedSet(this.client, this.makeKey(sessionIdentifier, SESSION_PAGES), this.settings.getExpirationTime()).remove(String.valueOf(page.getPageId()));
        this.client.delete(this.makeKey(sessionIdentifier, page.getPageId(), PAGE_DATA));
        this.client.delete(this.makeKey(sessionIdentifier, page.getPageId(), PAGE_TYPE));
        this.client.delete(this.makeKey(sessionIdentifier, page.getPageId(), PAGE_SIZE));
        LOG.debug("Removed the data for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    protected void removeAllPersistedPages(String sessionIdentifier) {
        MemcachedSet pages = new MemcachedSet(this.client, this.makeKey(sessionIdentifier, SESSION_PAGES), this.settings.getExpirationTime());
        for (String id : pages) {
            this.client.delete(this.makeKey(sessionIdentifier, id, PAGE_DATA));
            this.client.delete(this.makeKey(sessionIdentifier, id, PAGE_TYPE));
            this.client.delete(this.makeKey(sessionIdentifier, id, PAGE_SIZE));
        }
        this.client.delete(this.makeKey(sessionIdentifier, SESSION_PAGES));
        new MemcachedSet(this.client, this.makeKey(SESSIONS), this.settings.getExpirationTime()).remove(sessionIdentifier);
    }

    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("MemcachedDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        int expirationTime = this.settings.getExpirationTime();
        MemcachedSet pages = new MemcachedSet(this.client, this.makeKey(sessionIdentifier, SESSION_PAGES), expirationTime);
        if (pages.add(String.valueOf(page.getPageId()))) {
            MemcachedSet sessions = new MemcachedSet(this.client, this.makeKey(SESSIONS), this.settings.getExpirationTime());
            sessions.add(sessionIdentifier);
            sessions.compact();
        }
        this.client.set(this.makeKey(sessionIdentifier, serializedPage.getPageId(), PAGE_DATA), expirationTime, (Object)serializedPage.getData());
        this.client.set(this.makeKey(sessionIdentifier, serializedPage.getPageId(), PAGE_SIZE), expirationTime, (Object)serializedPage.getData().length);
        if (serializedPage.getPageType() != null) {
            this.client.set(this.makeKey(sessionIdentifier, serializedPage.getPageId(), PAGE_TYPE), expirationTime, (Object)serializedPage.getPageType());
        }
        pages.compact(pageId -> this.client.get(this.makeKey(sessionIdentifier, pageId, PAGE_SIZE)) != null);
        LOG.debug("Stored data for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    public void destroy() {
        if (this.client != null) {
            Duration timeout = this.settings.getShutdownTimeout();
            LOG.info("Shutting down gracefully for {}", (Object)timeout);
            this.client.shutdown(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private String makeKey(Object ... segments) {
        StringBuilder key = new StringBuilder();
        for (Object segment : segments) {
            if (key.length() > 0) {
                key.append(SEPARATOR);
            }
            key.append(segment);
        }
        key.append(SEPARATOR);
        key.append(KEY_SUFFIX);
        return key.toString();
    }

    public Set<String> getSessionIdentifiers() {
        return MemcachedSet.decodeSet((String)this.client.get(this.makeKey(SESSIONS)));
    }

    public List<IPersistedPage> getPersistedPages(String sessionIdentifier) {
        ArrayList<IPersistedPage> pages = new ArrayList<IPersistedPage>();
        for (String id : MemcachedSet.decodeSet((String)this.client.get(this.makeKey(sessionIdentifier, SESSION_PAGES)))) {
            Integer pageSize = (Integer)this.client.get(this.makeKey(sessionIdentifier, id, PAGE_SIZE));
            if (pageSize == null) continue;
            String pageType = (String)this.client.get(this.makeKey(sessionIdentifier, id, PAGE_TYPE));
            pages.add((IPersistedPage)new AbstractPersistentPageStore.PersistedPage(Integer.parseInt(id), pageType, (long)pageSize.intValue()));
        }
        return pages;
    }

    public Bytes getTotalSize() {
        return null;
    }
}

