/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.memcached;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.apache.wicket.util.string.Strings;

public class MemcachedSet
implements Iterable<String> {
    private static final String MINUS = "-";
    private static final String PLUS = "+";
    private final MemcachedClient client;
    private final String key;
    private final int expirationTime;

    public MemcachedSet(MemcachedClient client, String key, int expirationTime) {
        this.client = client;
        this.key = key;
        this.expirationTime = expirationTime;
    }

    @Override
    public Iterator<String> iterator() {
        return MemcachedSet.decodeSet((String)this.client.get(this.key)).iterator();
    }

    public boolean add(String value) {
        return this.modify(PLUS + value);
    }

    public boolean remove(String value) {
        return this.modify(MINUS + value);
    }

    private boolean modify(String modification) {
        if (modification.indexOf(32) != -1) {
            throw new IllegalArgumentException(String.format("value '%s' may not contain a space", modification.substring(1)));
        }
        boolean created = false;
        block2: while (true) {
            try {
                do {
                    if (!((Boolean)this.client.append(this.key, (Object)(" " + modification)).get()).booleanValue()) continue;
                    this.client.touch(this.key, this.expirationTime);
                    break block2;
                } while (!((Boolean)this.client.add(this.key, this.expirationTime, (Object)modification).get()).booleanValue());
                created = true;
            }
            catch (InterruptedException | ExecutionException exception) {
                continue;
            }
            break;
        }
        return created;
    }

    public void compact() {
        this.compact(page -> true);
    }

    public void compact(Predicate<String> predicate) {
        CASValue cas = this.client.gets(this.key);
        Set<String> set = MemcachedSet.decodeSet((String)cas.getValue());
        set = set.stream().filter(predicate).collect(Collectors.toSet());
        this.client.asyncCAS(this.key, cas.getCas(), (Object)MemcachedSet.encodeSet(set));
    }

    static String encodeSet(Set<String> pageIds) {
        if (pageIds.isEmpty()) {
            return "";
        }
        return PLUS + Strings.join((String)" +", (String[])pageIds.toArray(new String[pageIds.size()]));
    }

    static Set<String> decodeSet(String value) {
        HashSet<String> pageIds = new HashSet<String>();
        if (value != null) {
            for (String delta : Strings.split((String)value, (char)' ')) {
                if (delta.startsWith(PLUS)) {
                    pageIds.add(delta.substring(1).trim());
                    continue;
                }
                if (!delta.startsWith(MINUS)) continue;
                pageIds.remove(delta.substring(1).trim());
            }
        }
        return pageIds;
    }
}

