/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.memcached;

import java.time.Duration;
import java.util.List;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.datastores.memcached.IMemcachedSettings;

public class MemcachedSettings
implements IMemcachedSettings {
    private List<String> servers;
    private int port = 11211;
    private int expirationTime = 1800;
    private Duration shutdownTimeout = Duration.ofSeconds(10L);

    public MemcachedSettings() {
        this.setServerNames("localhost");
    }

    @Override
    public List<String> getServerList() {
        return this.servers;
    }

    @Override
    public IMemcachedSettings setServerNames(String serverNames) {
        Args.notEmpty((CharSequence)serverNames, (String)"serverNames");
        String[] ss = Strings.split((String)serverNames, (char)',');
        this.servers = Generics.newArrayList((int)ss.length);
        for (String server : ss) {
            this.servers.add(server.trim());
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public IMemcachedSettings setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public int getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public IMemcachedSettings setExpirationTime(int expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Override
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Override
    public IMemcachedSettings setShutdownTimeout(Duration timeout) {
        this.shutdownTimeout = (Duration)Args.notNull((Object)timeout, (String)"timeout");
        return this;
    }
}

