/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.redis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.redis.IRedisSettings;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.SafeEncoder;

public class RedisDataStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDataStore.class);
    private static final String ATTRIBUTES = "attributes";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String SIZE = "size";
    private final JedisPool jedisPool;
    private final IRedisSettings settings;
    private static final String KEY_PREFIX = "Wicket-Redis";
    private static final String SEPARATOR = "|||";

    public RedisDataStore(String applicationname, IRedisSettings settings) {
        this(applicationname, RedisDataStore.createPool(settings), settings);
    }

    private static JedisPool createPool(IRedisSettings settings) {
        Args.notNull((Object)settings, (String)"settings");
        JedisPool pool = new JedisPool(settings.getHostname(), settings.getPort());
        return pool;
    }

    public RedisDataStore(String applicationname, JedisPool pool, IRedisSettings settings) {
        super(applicationname);
        this.jedisPool = (JedisPool)Args.notNull((Object)pool, (String)"pool");
        this.settings = (IRedisSettings)Args.notNull((Object)settings, (String)"settings");
    }

    public boolean supportsVersioning() {
        return true;
    }

    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        try (Jedis resource = this.jedisPool.getResource();){
            String key = this.makeKey(sessionIdentifier, id);
            byte[] bytes = resource.get(SafeEncoder.encode((String)key));
            String attributesKey = this.makeKey(sessionIdentifier, id, ATTRIBUTES);
            String type = new String((String)resource.hmget(attributesKey, new String[]{TYPE}).get(0));
            LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{bytes != null ? "data" : "'null'", sessionIdentifier, id});
            SerializedPage serializedPage = new SerializedPage(id, type, bytes);
            return serializedPage;
        }
    }

    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        try (Jedis resource = this.jedisPool.getResource();){
            String key = this.makeKey(sessionIdentifier, page.getPageId());
            resource.del(key);
            String attributesKey = this.makeKey(sessionIdentifier, page.getPageId(), ATTRIBUTES);
            resource.del(attributesKey);
        }
        LOGGER.debug("Deleted data for session '{}' and page with id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    protected void removeAllPersistedPages(String sessionIdentifier) {
        try (Jedis resource = this.jedisPool.getResource();){
            String glob = this.makeKey(sessionIdentifier, "*");
            Set keys = resource.keys(glob);
            for (String key : keys) {
                resource.del(key);
            }
        }
        LOGGER.debug("Deleted data for session '{}'", (Object)sessionIdentifier);
    }

    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("RedisDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        try (Jedis resource = this.jedisPool.getResource();){
            String key = this.makeKey(sessionIdentifier, serializedPage.getPageId());
            resource.set(SafeEncoder.encode((String)key), serializedPage.getData());
            String attributesKey = this.makeKey(sessionIdentifier, serializedPage.getPageId(), ATTRIBUTES);
            resource.hmset(attributesKey, this.makeHm(serializedPage));
            if (this.settings.getRecordTtl() != null) {
                resource.expire(key, (long)((int)this.settings.getRecordTtl().toSeconds()));
                resource.expire(attributesKey, (long)((int)this.settings.getRecordTtl().toSeconds()));
            }
        }
        LOGGER.debug("Inserted data for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    public void destroy() {
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
        }
    }

    public Set<String> getSessionIdentifiers() {
        HashSet<String> sessionIdentifiers = new HashSet<String>();
        try (Jedis resource = this.jedisPool.getResource();){
            String glob = this.makeKey("*");
            Set keys = resource.keys(glob);
            for (String key : keys) {
                if (key.indexOf(SEPARATOR, glob.length()) != -1) continue;
                sessionIdentifiers.add(key);
            }
        }
        return sessionIdentifiers;
    }

    public List<IPersistedPage> getPersistedPages(String sessionIdentifier) {
        ArrayList<IPersistedPage> pages = new ArrayList<IPersistedPage>();
        try (Jedis resource = this.jedisPool.getResource();){
            String glob = this.makeKey(sessionIdentifier, "*");
            Set keys = resource.keys(glob);
            for (String key : keys) {
                if (!key.endsWith(ATTRIBUTES)) continue;
                AbstractPersistentPageStore.PersistedPage page = this.parseHm(resource, key);
                pages.add((IPersistedPage)page);
            }
        }
        return pages;
    }

    public Bytes getTotalSize() {
        return null;
    }

    private String makeKey(Object ... segments) {
        StringBuilder string = new StringBuilder();
        string.append(KEY_PREFIX);
        for (Object segment : segments) {
            string.append(SEPARATOR);
            string.append(segment);
        }
        return string.toString();
    }

    private Map<String, String> makeHm(SerializedPage serializedPage) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put(ID, String.valueOf(serializedPage.getPageId()));
        hm.put(TYPE, serializedPage.getPageType());
        hm.put(SIZE, String.valueOf(serializedPage.getData().length));
        return hm;
    }

    private AbstractPersistentPageStore.PersistedPage parseHm(Jedis resource, String key) {
        List hm = resource.hmget(key, new String[]{ID, TYPE, SIZE});
        return new AbstractPersistentPageStore.PersistedPage(Integer.parseInt((String)hm.get(0)), (String)hm.get(1), (long)Integer.parseInt((String)hm.get(2)));
    }
}

