/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.redis;

import java.nio.charset.Charset;
import java.util.Set;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.redis.IRedisSettings;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisDataStore
implements IDataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDataStore.class);
    private final JedisPool jedisPool;
    private final IRedisSettings settings;
    private static final String KEY_PREFIX = "Wicket-Redis";
    private static final String SEPARATOR = "|||";

    public RedisDataStore(IRedisSettings settings) {
        this(RedisDataStore.createPool(settings), settings);
    }

    private static JedisPool createPool(IRedisSettings settings) {
        Args.notNull((Object)settings, (String)"settings");
        JedisPool pool = new JedisPool(settings.getHostname(), settings.getPort());
        return pool;
    }

    public RedisDataStore(JedisPool pool, IRedisSettings settings) {
        this.jedisPool = (JedisPool)Args.notNull((Object)pool, (String)"pool");
        this.settings = (IRedisSettings)Args.notNull((Object)settings, (String)"settings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String sessionId, int pageId) {
        byte[] bytes = null;
        Jedis resource = (Jedis)this.jedisPool.getResource();
        try {
            byte[] key = this.makeKey(sessionId, pageId);
            bytes = resource.get(key);
            LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{bytes != null ? "data" : "'null'", sessionId, pageId});
        }
        finally {
            this.jedisPool.returnResource((Object)resource);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String sessionId, int pageId) {
        Jedis resource = (Jedis)this.jedisPool.getResource();
        try {
            byte[] key = this.makeKey(sessionId, pageId);
            resource.del(key);
        }
        finally {
            this.jedisPool.returnResource((Object)resource);
        }
        LOGGER.debug("Deleted data for session '{}' and page with id '{}'", (Object)sessionId, (Object)pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String sessionId) {
        Jedis resource = (Jedis)this.jedisPool.getResource();
        try {
            byte[] glob = this.makeGlob(sessionId);
            Set keys = resource.keys(glob);
            for (byte[] key : keys) {
                resource.del(key);
            }
        }
        finally {
            this.jedisPool.returnResource((Object)resource);
        }
        LOGGER.debug("Deleted data for session '{}'", (Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeData(String sessionId, int pageId, byte[] data) {
        Jedis resource = (Jedis)this.jedisPool.getResource();
        try {
            byte[] key = this.makeKey(sessionId, pageId);
            resource.set(key, data);
            if (this.settings.getRecordTtl() != null) {
                resource.expire(key, (int)this.settings.getRecordTtl().seconds());
            }
        }
        finally {
            this.jedisPool.returnResource((Object)resource);
        }
        LOGGER.debug("Inserted data for session '{}' and page id '{}'", (Object)sessionId, (Object)pageId);
    }

    public void destroy() {
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
        }
    }

    public boolean isReplicated() {
        return true;
    }

    public boolean canBeAsynchronous() {
        return true;
    }

    private byte[] makeKey(String sessionId, int pageId) {
        return this.makePrefix(sessionId).append(pageId).toString().getBytes(Charset.forName("UTF-8"));
    }

    private byte[] makeGlob(String sessionId) {
        return this.makePrefix(sessionId).append('*').toString().getBytes(Charset.forName("UTF-8"));
    }

    private StringBuilder makePrefix(String sessionId) {
        return new StringBuilder().append(KEY_PREFIX).append(SEPARATOR).append(sessionId).append(SEPARATOR);
    }
}

