/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import java.util.function.Supplier;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.mock.MockPageContext;
import org.apache.wicket.mock.MockPageStore;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Bytes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;

public class SessionQuotaManagingDataStoreTest {
    private SerializedPage page1 = new SerializedPage(1, new byte[4]);
    private SerializedPage page2 = new SerializedPage(2, new byte[3]);
    private SerializedPage page1_ = new SerializedPage(1, new byte[2]);
    private SerializedPage page3 = new SerializedPage(3, new byte[4]);

    @Test
    public void storeDataEnoughSpace() {
        MockPageStore delegate = new MockPageStore();
        MockPageContext context = new MockPageContext();
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore((IPageStore)delegate, Bytes.MAX);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page2);
        Assertions.assertEquals((int)2, (int)delegate.getPages().size());
        Assertions.assertEquals((Object)this.page1, delegate.getPages().get(0));
        Assertions.assertEquals((Object)this.page2, delegate.getPages().get(1));
    }

    @Test
    public void storeDataInsufficientSpace() {
        MockPageStore delegate = new MockPageStore();
        MockPageContext context = new MockPageContext();
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore((IPageStore)delegate, Bytes.bytes((long)(this.page1.getData().length + 1)));
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page2);
        Assertions.assertEquals((int)1, (int)delegate.getPages().size());
        Assertions.assertEquals((Object)this.page2, delegate.getPages().get(0));
    }

    @Test
    public void storeDataSamePageTwice() {
        MockPageStore delegate = new MockPageStore();
        MockPageContext context = new MockPageContext();
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore((IPageStore)delegate, Bytes.bytes((long)(this.page1_.getData().length + this.page2.getData().length)));
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1_);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page2);
        Assertions.assertEquals((int)2, (int)delegate.getPages().size());
        Assertions.assertEquals((Object)this.page1_, delegate.getPages().get(0));
        Assertions.assertEquals((Object)this.page2, delegate.getPages().get(1));
    }

    @Test
    public void removePage() {
        MockPageStore delegate = new MockPageStore();
        MockPageContext context = new MockPageContext();
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore((IPageStore)delegate, Bytes.bytes((long)(this.page1.getData().length + this.page3.getData().length)));
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page2);
        quotaStore.removePage((IPageContext)context, (IManageablePage)this.page2);
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page3);
        Assertions.assertEquals((int)2, (int)delegate.getPages().size());
        Assertions.assertEquals((Object)this.page1, delegate.getPages().get(0));
        Assertions.assertEquals((Object)this.page3, delegate.getPages().get(1));
    }

    @Test
    public void removePageShouldNotSupplyDefaultValueWhenGettingSessionData() {
        MockPageStore delegate = new MockPageStore();
        IPageContext context = (IPageContext)Mockito.mock(IPageContext.class);
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore((IPageStore)delegate, Bytes.bytes((long)(this.page1.getData().length + this.page3.getData().length)));
        quotaStore.removePage(context, (IManageablePage)this.page1);
        ((IPageContext)Mockito.verify((Object)context)).getSessionData((MetaDataKey)ArgumentMatchers.any(MetaDataKey.class), (Supplier)ArgumentMatchers.eq(null));
    }

    @Test
    void addPageDoesNotRemovePageFromDelegate() {
        IPageStore delegate = (IPageStore)Mockito.mock(IPageStore.class);
        MockPageContext context = new MockPageContext();
        SessionQuotaManagingDataStore quotaStore = new SessionQuotaManagingDataStore(delegate, Bytes.bytes((long)(this.page1.getData().length + this.page3.getData().length)));
        quotaStore.addPage((IPageContext)context, (IManageablePage)this.page1);
        ((IPageStore)Mockito.verify((Object)delegate, (VerificationMode)Mockito.never())).removePage((IPageContext)context, (IManageablePage)this.page1);
        ((IPageStore)Mockito.verify((Object)delegate)).addPage((IPageContext)context, (IManageablePage)this.page1);
    }
}

