/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables;

import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import de.agilecoders.wicket.jquery.util.Json;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.datatables.Sort;

public class Options
extends AbstractConfig {
    private static final IKey<Sort[]> Order = new Key("order", null);
    private static final IKey<Boolean> StateSave = new Key("stateSave", (Object)false);
    private static final IKey<Integer> StateDuration = new Key("stateDuration", (Object)7200);
    private static final IKey<PagingType> _PagingType = new Key("pagingType", (Object)PagingType.simple_numbers);
    private static final IKey<Boolean> Paging = new Key("paging", (Object)true);
    private static final IKey<String> ScrollY = new Key("scrollY", null);
    private static final IKey<Boolean> ScrollCollapse = new Key("scrollCollapse", (Object)false);
    private static final IKey<Boolean> ScrollX = new Key("scrollX", (Object)false);
    private static final IKey<Json.RawValue> RowCallback = new Key("rowCallback", null);
    private static final IKey<Integer[]> DeferLoading = new Key("deferLoading", null);
    private static final IKey<Json.RawValue> CreatedRow = new Key("createdRow", null);
    private static final IKey<Object[][]> LengthMenu = new Key("lengthMenu", null);

    public Options lengthMenu(Integer[] values, String[] displayValues) {
        Args.notNull((Object)values, (String)"values");
        Args.notNull((Object)displayValues, (String)"displayValues");
        Args.isTrue((values.length == displayValues.length ? 1 : 0) != 0, (String)"The values and display values length are different!", (Object[])new Object[0]);
        this.put(LengthMenu, new Object[][]{values, displayValues});
        return this;
    }

    public Options createdRow(Json.RawValue createdRow) {
        this.put(CreatedRow, createdRow);
        return this;
    }

    public Options deferLoading(Integer maxItems) {
        this.put(DeferLoading, new Integer[]{maxItems});
        return this;
    }

    public Options deferLoadingFiltered(int maxItemsFiltered, int maxItems) {
        this.put(DeferLoading, new Integer[]{maxItemsFiltered, maxItems});
        return this;
    }

    public Options rowCallback(Json.RawValue rowCallback) {
        this.put(RowCallback, rowCallback);
        return this;
    }

    public Options scrollX(Boolean scrollX) {
        this.put(ScrollX, scrollX);
        return this;
    }

    public Options scrollCollapse(Boolean scrollCollapse) {
        this.put(ScrollCollapse, scrollCollapse);
        return this;
    }

    public Options scrollY(String scrollY) {
        this.put(ScrollY, scrollY);
        return this;
    }

    public Options paging(Boolean paging) {
        this.put(Paging, paging);
        return this;
    }

    public Options pagingType(PagingType pagingType) {
        this.put(_PagingType, (Object)pagingType);
        return this;
    }

    public Options stateSave(Boolean stateSave) {
        this.put(StateSave, stateSave);
        return this;
    }

    public Options stateDuration(Integer duration) {
        this.put(StateDuration, duration);
        return this;
    }

    public Options order(Sort ... sortParams) {
        this.put(Order, sortParams);
        return this;
    }

    public static enum PagingType {
        simple,
        simple_numbers,
        full,
        full_numbers;

    }
}

