/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables;

import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.repeater.data.EmptyDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.wicketstuff.datatables.DataTablesBehavior;
import org.wicketstuff.datatables.options.Options;

public class DataTables<T, S>
extends DataTable<T, S> {
    public static final int ZERO_ROWS_PER_PAGE = Integer.MIN_VALUE;
    private final Options options;
    private final long rowsPerPage;

    public DataTables(String id, List<? extends IColumn<T, S>> columns) {
        this(id, (List<IColumn<T, S>>)columns, (IDataProvider<T>)new EmptyDataProvider(), Integer.MIN_VALUE);
    }

    public DataTables(String id, List<? extends IColumn<T, S>> iColumns, IDataProvider<T> dataProvider, long rowsPerPage) {
        super(id, iColumns, dataProvider, rowsPerPage == Integer.MIN_VALUE ? 1L : rowsPerPage);
        this.rowsPerPage = rowsPerPage;
        this.setOutputMarkupId(true);
        this.options = new Options();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.newDataTablesBehavior()});
    }

    protected Behavior newDataTablesBehavior() {
        return new DataTablesBehavior(this.options);
    }

    public Options getOptions() {
        return this.options;
    }

    public void repaint(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("window['%s'].api().ajax.reload();", this.getJsHandle()));
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.isEnabledInHierarchy()) {
            String dataTableFn = JQuery.$((Component)this).chain((CharSequence)"dataTable", (Config)this.getOptions(), new Config[0]).get();
            String setup = String.format("window['%s'] = %s", this.getJsHandle(), dataTableFn);
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)setup));
        }
    }

    public String getJsHandle() {
        return "WS_DT_" + Strings2.escapeMarkupId((CharSequence)this.getMarkupId());
    }

    protected DataGridView<T> newDataGridView(String id, List<? extends IColumn<T, S>> iColumns, IDataProvider<T> dataProvider) {
        return new DataGridView<T>(id, iColumns, dataProvider){

            public long getItemsPerPage() {
                return DataTables.this.rowsPerPage;
            }
        };
    }
}

