/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.datatables.options.Options;
import org.wicketstuff.datatables.res.DataTablesCssReference;
import org.wicketstuff.datatables.res.DataTablesJsReference;
import org.wicketstuff.datatables.res.DataTablesScrollerJsReference;
import org.wicketstuff.datatables.res.DataTablesSelectJsReference;

public class DataTablesBehavior
extends Behavior {
    private final Options options;

    public DataTablesBehavior(Options options) {
        this.options = options;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        tag.append("class", (CharSequence)"display", " ");
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        boolean shouldRenderCss = this.shouldRenderCss();
        if (shouldRenderCss) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new DataTablesCssReference()));
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new DataTablesJsReference()));
        Options.Style style = this.options.getStyle();
        if (shouldRenderCss) {
            style.renderHead(response, "dataTables");
        }
        if (this.options.contains(Options.Scroller)) {
            if (shouldRenderCss) {
                style.renderHead(response, "scroller");
            }
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new DataTablesScrollerJsReference()));
        }
        if (this.options.contains(Options.Select)) {
            if (shouldRenderCss) {
                style.renderHead(response, "select");
            }
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new DataTablesSelectJsReference()));
        }
    }

    protected boolean shouldRenderCss() {
        return true;
    }
}

