/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables.columns;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.datatables.IDataTablesColumn;

public class SpanHeadersToolbar<S>
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public <T> SpanHeadersToolbar(final DataTable<T, S> table, final IDataTablesColumn<T, S> ... columns) {
        super(table);
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                List<IDataTablesColumn> tableColumns = columns != null && columns.length > 0 ? Arrays.asList(columns) : table.getColumns();
                for (IColumn iColumn : tableColumns) {
                    columnsModels.add(Model.of((Serializable)iColumn));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                final IColumn column = (IColumn)item.getModelObject();
                WebMarkupContainer header = new WebMarkupContainer("header");
                if (column instanceof IDataTablesColumn) {
                    IDataTablesColumn dtColumn = (IDataTablesColumn)column;
                    if (dtColumn.getColspan() > 0) {
                        header.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (Serializable)Integer.valueOf(dtColumn.getColspan()))});
                    }
                    if (dtColumn.getRowspan() > 0) {
                        header.add(new Behavior[]{AttributeModifier.replace((String)"rowspan", (Serializable)Integer.valueOf(dtColumn.getRowspan() - 1))});
                    }
                }
                if (column instanceof IStyledColumn) {
                    Behavior cssAttributeBehavior = new Behavior(){
                        private static final long serialVersionUID = 1L;

                        public void onComponentTag(Component component, ComponentTag tag) {
                            super.onComponentTag(component, tag);
                            String cssClass = ((IStyledColumn)column).getCssClass();
                            if (!Strings.isEmpty((CharSequence)cssClass)) {
                                tag.append("class", (CharSequence)cssClass, " ");
                            }
                        }
                    };
                    header.add(new Behavior[]{cssAttributeBehavior});
                }
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
                header.add(new Component[]{column.getHeader("label")});
            }
        };
        this.add(new Component[]{headers});
    }
}

