/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables.options;

import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import de.agilecoders.wicket.jquery.util.Json;
import java.util.List;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.datatables.Sort;
import org.wicketstuff.datatables.options.Column;
import org.wicketstuff.datatables.options.ScrollerOptions;
import org.wicketstuff.datatables.options.SelectOptions;
import org.wicketstuff.datatables.res.DataTablesCssReference;

public class Options
extends AbstractConfig {
    public static final IKey<Sort[]> Order = new Key("order", null);
    public static final IKey<Boolean> StateSave = new Key("stateSave", (Object)false);
    public static final IKey<Integer> StateDuration = new Key("stateDuration", (Object)7200);
    public static final IKey<PagingType> _PagingType = new Key("pagingType", (Object)PagingType.simple_numbers);
    public static final IKey<Boolean> Paging = new Key("paging", (Object)true);
    public static final IKey<String> ScrollY = new Key("scrollY", null);
    public static final IKey<String> Dom = new Key("dom", (Object)"lfrtip");
    public static final IKey<Boolean> ScrollCollapse = new Key("scrollCollapse", (Object)false);
    public static final IKey<Boolean> ScrollX = new Key("scrollX", (Object)false);
    public static final IKey<Boolean> ServerSide = new Key("serverSide", (Object)false);
    public static final IKey<Boolean> Ordering = new Key("ordering", (Object)true);
    public static final IKey<Boolean> Searching = new Key("searching", (Object)true);
    public static final IKey<Boolean> DeferRender = new Key("deferRender", (Object)false);
    public static final IKey<Boolean> Info = new Key("info", (Object)true);
    public static final IKey<Boolean> Processing = new Key("processing", (Object)false);
    public static final IKey<String> Ajax = new Key("ajax", null);
    public static final IKey<Json.RawValue> RowId = new Key("rowId", (Object)new Json.RawValue("'DT_RowId'"));
    public static final IKey<ScrollerOptions> Scroller = new Key("scroller", null);
    public static final IKey<SelectOptions> Select = new Key("select", null);
    public static final IKey<Json.RawValue> RowCallback = new Key("rowCallback", null);
    public static final IKey<Integer[]> DeferLoading = new Key("deferLoading", null);
    public static final IKey<Json.RawValue> CreatedRow = new Key("createdRow", null);
    public static final IKey<Json.RawValue> Render = new Key("render", null);
    public static final IKey<Object[][]> LengthMenu = new Key("lengthMenu", null);
    public static final IKey<List<Column>> Columns = new Key("columns", null);
    public static final IKey<Integer> PageLength = new Key("pageLength", null);
    public static final IKey<Boolean> Retrieve = new Key("retrieve", (Object)false);
    private Style style = Style.none;

    public Options style(Style style) {
        if (style == null) {
            style = Style.none;
        }
        this.style = style;
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public Options columns(List<Column> columns) {
        this.put(Columns, columns);
        return this;
    }

    public Options lengthMenu(Integer[] values, String[] displayValues) {
        Args.notNull((Object)values, (String)"values");
        Args.notNull((Object)displayValues, (String)"displayValues");
        Args.isTrue((values.length == displayValues.length ? 1 : 0) != 0, (String)"The values and display values length are different!", (Object[])new Object[0]);
        this.put(LengthMenu, new Object[][]{values, displayValues});
        return this;
    }

    public Options createdRow(Json.RawValue createdRow) {
        this.put(CreatedRow, createdRow);
        return this;
    }

    public Options render(Json.RawValue render) {
        this.put(Render, render);
        return this;
    }

    public Options deferLoading(Integer maxItems) {
        this.put(DeferLoading, new Integer[]{maxItems});
        return this;
    }

    public Options deferLoadingFiltered(int maxItemsFiltered, int maxItems) {
        this.put(DeferLoading, new Integer[]{maxItemsFiltered, maxItems});
        return this;
    }

    public Options rowCallback(Json.RawValue rowCallback) {
        this.put(RowCallback, rowCallback);
        return this;
    }

    public Options scrollX(boolean scrollX) {
        this.put(ScrollX, scrollX);
        return this;
    }

    public Options info(boolean info) {
        this.put(Info, info);
        return this;
    }

    public Options retrieve(boolean retrieve) {
        this.put(Retrieve, retrieve);
        return this;
    }

    public Options processing(boolean processing) {
        this.put(Processing, processing);
        return this;
    }

    public Options serverSide(boolean serverSide) {
        this.put(ServerSide, serverSide);
        return this;
    }

    public Options ordering(boolean ordering) {
        this.put(Ordering, ordering);
        return this;
    }

    public Options searching(boolean searching) {
        this.put(Searching, searching);
        return this;
    }

    public Options deferRender(boolean deferRender) {
        this.put(DeferRender, deferRender);
        return this;
    }

    public Options scroller(ScrollerOptions scroller) {
        this.scrollCollapse(false);
        this.paging(true);
        this.put(Scroller, (Object)scroller);
        return this;
    }

    public Options select(SelectOptions select) {
        this.put(Select, (Object)select);
        return this;
    }

    public Options ajax(CharSequence ajax) {
        this.put(Ajax, String.valueOf(ajax));
        return this;
    }

    public Options scrollCollapse(boolean scrollCollapse) {
        this.put(ScrollCollapse, scrollCollapse);
        return this;
    }

    public Options scrollY(String scrollY) {
        this.put(ScrollY, scrollY);
        return this;
    }

    public Options rowId(Json.RawValue rowId) {
        this.put(RowId, rowId);
        return this;
    }

    public Options dom(String dom) {
        this.put(Dom, dom);
        return this;
    }

    public Options paging(boolean paging) {
        this.put(Paging, paging);
        return this;
    }

    public Options pagingType(PagingType pagingType) {
        this.put(_PagingType, (Object)pagingType);
        return this;
    }

    public Options stateSave(boolean stateSave) {
        this.put(StateSave, stateSave);
        return this;
    }

    public Options pageLength(int pageLength) {
        this.put(PageLength, pageLength);
        return this;
    }

    public Options stateDuration(int duration) {
        this.put(StateDuration, duration);
        return this;
    }

    public Options order(Sort ... sortParams) {
        this.put(Order, sortParams);
        return this;
    }

    public static enum Style {
        dataTables,
        bootstrap,
        foundation,
        jqueryui,
        none;


        public void renderHead(IHeaderResponse response, String pluginName) {
            if (!(none == this || dataTables == this && "dataTables".equals(pluginName))) {
                String name = "css/" + pluginName + "." + this.name() + ".css";
                CssResourceReference cssReference = new CssResourceReference(DataTablesCssReference.class, name);
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)cssReference));
            }
        }
    }

    public static enum PagingType {
        numbers,
        simple,
        simple_numbers,
        full,
        full_numbers;

    }
}

