/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datatables.virtualscroll;

import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CharSequenceResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AbstractVirtualScrollResourceReference<T>
extends ResourceReference {
    public static final String LENGTH_PARAMETER = "length";
    public static final String START_PARAMETER = "start";
    public static final String DRAW_PARAMETER = "draw";
    public static final String ORDER_0_COLUMN_PARAMETER = "order[0][column]";
    public static final String ORDER_0_DIRECTION_PARAMETER = "order[0][dir]";
    public static final String ASCENDING_DIRECTION = "asc";
    public static final String DESCENDING_DIRECTION = "desc";
    public static final String SEARCH_VALUE_PARAMETER = "search[value]";
    public static final String SEARCH_REGEX_PARAMETER = "search[regex]";
    public static final String RECORDS_TOTAL_RESPONSE_FIELD = "recordsTotal";
    public static final String RECORDS_FILTERED_RESPONSE_FIELD = "recordsFiltered";
    public static final String DRAW_RESPONSE_FIELD = "draw";
    public static final String DATA_RESPONSE_FIELD = "data";

    public AbstractVirtualScrollResourceReference(ResourceReference.Key key) {
        super(key);
    }

    public AbstractVirtualScrollResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    public AbstractVirtualScrollResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public AbstractVirtualScrollResourceReference(String name) {
        super(name);
    }

    public IResource getResource() {
        return new CharSequenceResource("application/json"){

            protected CharSequence getData(IResource.Attributes attributes) {
                PageParameters parameters = attributes.getParameters();
                WebResponse webResponse = (WebResponse)attributes.getResponse();
                webResponse.disableCaching();
                String response = AbstractVirtualScrollResourceReference.this.generateResponse(parameters);
                return response;
            }
        };
    }

    protected String generateResponse(PageParameters parameters) {
        int length = parameters.get(LENGTH_PARAMETER).toInt(this.getDefaultLength());
        int start = parameters.get(START_PARAMETER).toInt(this.getDefaultStart());
        IDataProvider<T> dataProvider = this.getDataProvider(parameters);
        Iterator dataItor = dataProvider.iterator((long)start, (long)length);
        JSONObject responseJson = new JSONObject();
        JSONArray data = new JSONArray();
        responseJson.put(DATA_RESPONSE_FIELD, (Object)data);
        while (dataItor.hasNext()) {
            Object dataEntry = dataItor.next();
            JSONObject entryJson = new JSONObject();
            this.populateEntryJson(entryJson, dataEntry);
            data.put((Object)entryJson);
        }
        responseJson.put("draw", parameters.get("draw").toInt(1));
        this.populateDataJson(responseJson, dataProvider);
        return responseJson.toString(2);
    }

    protected void populateDataJson(JSONObject response, IDataProvider<T> dataProvider) {
        long size = dataProvider.size();
        response.put(RECORDS_TOTAL_RESPONSE_FIELD, size);
        response.put(RECORDS_FILTERED_RESPONSE_FIELD, size);
    }

    protected abstract void populateEntryJson(JSONObject var1, T var2);

    protected abstract IDataProvider<T> getDataProvider(PageParameters var1);

    protected int getDefaultStart() {
        return 0;
    }

    protected int getDefaultLength() {
        return 100;
    }
}

