/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.menu;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jwicket.IStyleResolver;
import org.wicketstuff.jwicket.JQueryCssResourceReference;
import org.wicketstuff.menu.Menu;
import org.wicketstuff.menu.MenuPanel;

public class MenuBarPanel
extends Panel
implements IStyleResolver {
    private static final long serialVersionUID = 1L;
    public static JQueryCssResourceReference[] CSS = new JQueryCssResourceReference[]{new JQueryCssResourceReference(MenuBarPanel.class, "menu.css")};
    protected final List<Menu> menus;
    private static final AttributeModifier idSingleMenu = AttributeModifier.replace((String)"class", (Serializable)((Object)"singleMenu"));
    private static final AttributeModifier idFirstMenu = AttributeModifier.replace((String)"class", (Serializable)((Object)"firstMenu"));
    private static final AttributeModifier idMiddleMenu = AttributeModifier.replace((String)"class", (Serializable)((Object)"middleMenu"));
    private static final AttributeModifier idLastMenu = AttributeModifier.replace((String)"class", (Serializable)((Object)"lastMenu"));
    private final WebMarkupContainer menubar;
    private boolean browserDetected = false;
    private boolean browserIsIe56 = false;

    public MenuBarPanel(String id, List<Menu> menus) {
        super(id);
        this.menus = menus;
        this.menubar = new WebMarkupContainer("menubar");
        this.menubar.setOutputMarkupId(true);
        this.add(new Component[]{this.menubar});
    }

    protected void onBeforeRender() {
        if (!this.browserDetected) {
            WebClientInfo ci = WebSession.get().getClientInfo();
            if (ci instanceof WebClientInfo) {
                ClientProperties properties = ci.getProperties();
                if (properties.isBrowserInternetExplorer() && properties.getBrowserVersionMajor() < 7) {
                    this.browserIsIe56 = true;
                }
            } else {
                this.browserIsIe56 = true;
            }
            this.browserDetected = true;
        }
        this.menubar.addOrReplace(new Component[]{new Loop("menus", this.menus.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                Menu menu = MenuBarPanel.this.menus.get(index);
                if (menu.isVisible()) {
                    item.add(new Component[]{new Label("menuTitle", menu.getModel()).setRenderBodyOnly(true)});
                    MenuPanel mp = new MenuPanel("menu", menu.getMenuItems());
                    item.add(new Component[]{mp});
                    mp.setRenderBodyOnly(true);
                    if (index == 0) {
                        if (MenuBarPanel.this.menus.size() == 1) {
                            item.add(new Behavior[]{idSingleMenu});
                        } else {
                            item.add(new Behavior[]{idFirstMenu});
                        }
                    } else if (index == MenuBarPanel.this.menus.size() - 1) {
                        item.add(new Behavior[]{idLastMenu});
                    } else {
                        item.add(new Behavior[]{idMiddleMenu});
                    }
                } else {
                    item.setVisible(false);
                }
                item.add(new Behavior[]{AttributeModifier.replace((String)"onmouseover", (Serializable)((Object)"this.className+=' over';"))});
                item.add(new Behavior[]{AttributeModifier.replace((String)"onmouseout", (Serializable)((Object)"this.className=this.className.replace(' over','');"))});
                item.setOutputMarkupId(true);
                menu.setAssociatedComponent((Component)item);
            }
        }});
        super.onBeforeRender();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        JQueryCssResourceReference[] cssResources = this.getCssResources();
        if (cssResources != null) {
            for (JQueryCssResourceReference cssResource : cssResources) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)cssResource));
            }
        }
    }

    public void refresh(AjaxRequestTarget target) {
        target.add(new Component[]{this.menubar});
    }

    public JQueryCssResourceReference[] getCssResources() {
        return CSS;
    }
}

