/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gae;

import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.PageStoreManager;
import org.apache.wicket.pageStore.DefaultPageStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.memory.HttpSessionDataStore;
import org.apache.wicket.pageStore.memory.IDataStoreEvictionStrategy;
import org.apache.wicket.serialize.ISerializer;

public class GaePageManagerProvider
extends DefaultPageManagerProvider {
    private final Application application;
    private final IDataStoreEvictionStrategy evictionStrategy;

    public GaePageManagerProvider(Application application, IDataStoreEvictionStrategy evictionStrategy) {
        super(application);
        this.application = application;
        this.evictionStrategy = evictionStrategy;
    }

    public IPageManager get(IPageManagerContext pageManagerContext) {
        HttpSessionDataStore dataStore = new HttpSessionDataStore(pageManagerContext, this.evictionStrategy);
        int cacheSize = this.application.getStoreSettings().getInmemoryCacheSize();
        ISerializer pageSerializer = this.application.getFrameworkSettings().getSerializer();
        DefaultPageStore pageStore = new DefaultPageStore(pageSerializer, (IDataStore)dataStore, cacheSize);
        return new PageStoreManager(this.application.getName(), (IPageStore)pageStore, pageManagerContext);
    }
}

