/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.cdi.glassfish;

import com.sun.enterprise.container.common.spi.util.JavaEEObjectInputStream;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectOutputStream;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectStreamHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassfishSerializer
implements ISerializer {
    private static final Logger LOG = LoggerFactory.getLogger(GlassfishSerializer.class);
    private ISerializer fallback;

    public GlassfishSerializer(ISerializer fallback) {
        Args.notNull((Object)fallback, (String)"Fallback Serializer");
        this.fallback = fallback;
    }

    public Object deserialize(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ArrayList<JavaEEObjectStreamHandler> handlers = new ArrayList<JavaEEObjectStreamHandler>();
            handlers.add(this.getHandler());
            JavaEEObjectInputStream q = new JavaEEObjectInputStream((InputStream)bais, this.getClass().getClassLoader(), true, handlers);
            return q.readObject();
        }
        catch (Exception e) {
            LOG.warn("Caught Exception attempting to deserialize. Falling Back\n {} ", (Throwable)e);
            return this.fallback.deserialize(data);
        }
    }

    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArrayList<JavaEEObjectStreamHandler> handlers = new ArrayList<JavaEEObjectStreamHandler>();
            handlers.add(this.getHandler());
            JavaEEObjectOutputStream oos = new JavaEEObjectOutputStream((OutputStream)baos, true, handlers);
            oos.writeObject(object);
            return baos.toByteArray();
        }
        catch (Exception e) {
            LOG.warn("Caught Exception attempting to serialize. Falling Back\n {} ", (Throwable)e);
            return this.fallback.serialize(object);
        }
    }

    private JavaEEObjectStreamHandler getHandler() throws Exception {
        return new GlassfishStreamHandler();
    }

    public static class GlassfishStreamHandler
    implements JavaEEObjectStreamHandler {
        private Class indirectlySerializableClass;
        private Class serializableObjectFactoryClass;

        public GlassfishStreamHandler() throws ClassNotFoundException {
            try {
                this.indirectlySerializableClass = Class.forName("com.sun.ejb.spi.io.IndirectlySerializable");
                this.serializableObjectFactoryClass = Class.forName("com.sun.ejb.spi.io.SerializableObjectFactory");
            }
            catch (ClassNotFoundException cnfe) {
                this.indirectlySerializableClass = Class.forName("com.sun.enterprise.container.common.spi.util.IndirectlySerializable");
                this.serializableObjectFactoryClass = Class.forName("com.sun.enterprise.container.common.spi.util.SerializableObjectFactory");
            }
        }

        public Object replaceObject(Object obj) throws IOException {
            Object result = obj;
            try {
                if (this.indirectlySerializableClass.isAssignableFrom(obj.getClass())) {
                    result = this.indirectlySerializableClass.getMethod("getSerializableObjectFactory", new Class[0]).invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error("Caught Exception in replaceObject", (Throwable)e);
            }
            return result;
        }

        public Object resolveObject(Object obj) throws IOException {
            Object result = obj;
            try {
                if (this.serializableObjectFactoryClass.isAssignableFrom(obj.getClass())) {
                    result = this.serializableObjectFactoryClass.getMethod("createObject", new Class[0]).invoke(obj, new Object[0]);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error("Caught Exception in resolveObject", (Throwable)e);
            }
            return result;
        }
    }
}

