/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.gmap.GMapHeaderContributor;
import wicket.contrib.gmap.GOverlayContainer;
import wicket.contrib.gmap.api.GControl;
import wicket.contrib.gmap.api.GEvent;
import wicket.contrib.gmap.api.GInfoWindow;
import wicket.contrib.gmap.api.GLatLng;
import wicket.contrib.gmap.api.GLatLngBounds;
import wicket.contrib.gmap.api.GMapType;
import wicket.contrib.gmap.api.GMarker;
import wicket.contrib.gmap.api.GOverlay;
import wicket.contrib.gmap.event.GEventListenerBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMap2
extends Panel
implements GOverlayContainer {
    private static final Logger log = LoggerFactory.getLogger(GMap2.class);
    private static final long serialVersionUID = 1L;
    private GLatLng center = new GLatLng(37.4419, -122.1419);
    private boolean googleBarEnabled = false;
    private boolean draggingEnabled = true;
    private boolean doubleClickZoomEnabled = false;
    private boolean scrollWheelZoomEnabled = false;
    private GMapType mapType = GMapType.G_NORMAL_MAP;
    private int zoom = 13;
    private final Set<GControl> controls = new HashSet<GControl>();
    private final List<GOverlay> overlays = new ArrayList<GOverlay>();
    private final WebMarkupContainer map;
    private final GInfoWindow infoWindow;
    private GLatLngBounds bounds;
    private final OverlayListener overlayListener;

    public GMap2(String id, String gMapKey) {
        this(id, new GMapHeaderContributor(gMapKey), new ArrayList<GOverlay>());
    }

    @Deprecated
    public GMap2(String id, String gMapKey, List<GOverlay> overlays) {
        this(id, new GMapHeaderContributor(gMapKey), overlays);
    }

    public GMap2(String id, GMapHeaderContributor headerContrib) {
        super(id);
        this.add(new Behavior[]{headerContrib});
        this.infoWindow = new GInfoWindow();
        this.add(new Component[]{this.infoWindow});
        this.map = new WebMarkupContainer("map");
        this.map.setOutputMarkupId(true);
        this.add(new Component[]{this.map});
        this.overlayListener = new OverlayListener();
        this.add(new Behavior[]{this.overlayListener});
    }

    @Deprecated
    public GMap2(String id, GMapHeaderContributor headerContrib, List<GOverlay> overlays) {
        this(id, headerContrib);
        for (GOverlay overlay : overlays) {
            this.addOverlay(overlay);
        }
    }

    public void renderHead(IHeaderResponse response) {
        response.renderOnDomReadyJavaScript(this.getJSinit());
    }

    protected void onBeforeRender() {
        RuntimeConfigurationType configurationType = Application.get().getConfigurationType();
        if (configurationType.equals((Object)RuntimeConfigurationType.DEVELOPMENT) && !Application.get().getMarkupSettings().getStripWicketTags()) {
            log.warn("Application is in DEVELOPMENT mode && Wicket tags are not stripped, Firefox 3.0 will not render the GMap. Change to DEPLOYMENT mode  || turn on Wicket tags stripping. See: http://www.nabble.com/Gmap2-problem-with-Firefox-3.0-to18137475.html.");
        }
        super.onBeforeRender();
    }

    public GMap2 addControl(GControl control) {
        this.controls.add(control);
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)control.getJSadd(this));
        }
        return this;
    }

    public GMap2 removeControl(GControl control) {
        this.controls.remove(control);
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)control.getJSremove(this));
        }
        return this;
    }

    @Override
    public GMap2 addOverlay(GOverlay overlay) {
        this.overlays.add(overlay);
        overlay.setParent(this);
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)overlay.getJSadd());
        }
        return this;
    }

    @Override
    public GMap2 removeOverlay(GOverlay overlay) {
        while (this.overlays.contains(overlay)) {
            this.overlays.remove(overlay);
        }
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)overlay.getJSremove());
        }
        overlay.setParent(null);
        return this;
    }

    @Override
    public GMap2 removeAllOverlays() {
        for (GOverlay overlay : this.overlays) {
            overlay.setParent(null);
        }
        this.overlays.clear();
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSinvoke("clearOverlays()"));
        }
        return this;
    }

    @Override
    public List<GOverlay> getOverlays() {
        return Collections.unmodifiableList(this.overlays);
    }

    public Set<GControl> getControls() {
        return Collections.unmodifiableSet(this.controls);
    }

    public GLatLng getCenter() {
        return this.center;
    }

    public GLatLngBounds getBounds() {
        return this.bounds;
    }

    public void enableGoogleBar(boolean enabled) {
        if (this.googleBarEnabled != enabled) {
            this.googleBarEnabled = enabled;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetGoogleBarEnabled(enabled));
            }
        }
    }

    public void setDraggingEnabled(boolean enabled) {
        if (this.draggingEnabled != enabled) {
            this.draggingEnabled = enabled;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetDraggingEnabled(enabled));
            }
        }
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public void setDoubleClickZoomEnabled(boolean enabled) {
        if (this.doubleClickZoomEnabled != enabled) {
            this.doubleClickZoomEnabled = enabled;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetDoubleClickZoomEnabled(enabled));
            }
        }
    }

    public boolean isDoubleClickZoomEnabled() {
        return this.doubleClickZoomEnabled;
    }

    public void setScrollWheelZoomEnabled(boolean enabled) {
        if (this.scrollWheelZoomEnabled != enabled) {
            this.scrollWheelZoomEnabled = enabled;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetScrollWheelZoomEnabled(enabled));
            }
        }
    }

    public boolean isScrollWheelZoomEnabled() {
        return this.scrollWheelZoomEnabled;
    }

    public GMapType getMapType() {
        return this.mapType;
    }

    public void setMapType(GMapType mapType) {
        if (this.mapType != mapType) {
            this.mapType = mapType;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)mapType.getJSsetMapType(this));
            }
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int level) {
        if (this.zoom != level) {
            this.zoom = level;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetZoom(this.zoom));
            }
        }
    }

    public void setCenter(GLatLng center) {
        if (!this.center.equals(center)) {
            this.center = center;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSsetCenter(center));
            }
        }
    }

    public void panTo(GLatLng center) {
        if (!this.center.equals(center)) {
            this.center = center;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSpanTo(center));
            }
        }
    }

    public GInfoWindow getInfoWindow() {
        return this.infoWindow;
    }

    private String getJSinit() {
        StringBuffer js = new StringBuffer("new WicketMap2('" + this.map.getMarkupId() + "');\n");
        js.append(this.overlayListener.getJSinit());
        js.append(this.getJSsetCenter(this.getCenter()));
        js.append(this.getJSsetZoom(this.getZoom()));
        js.append(this.getJSsetDraggingEnabled(this.draggingEnabled));
        js.append(this.getJSsetDoubleClickZoomEnabled(this.doubleClickZoomEnabled));
        js.append(this.getJSsetScrollWheelZoomEnabled(this.scrollWheelZoomEnabled));
        js.append(this.getJSsetGoogleBarEnabled(this.googleBarEnabled));
        js.append(this.mapType.getJSsetMapType(this));
        for (GControl control : this.controls) {
            js.append(control.getJSadd(this));
        }
        for (GOverlay overlay : this.overlays) {
            js.append(overlay.getJSadd());
        }
        js.append(this.infoWindow.getJSinit());
        for (GEventListenerBehavior behavior : this.getBehaviors(GEventListenerBehavior.class)) {
            js.append(behavior.getJSaddListener());
        }
        return js.toString();
    }

    public String getJSinvoke(String invocation) {
        return "Wicket.maps['" + this.map.getMarkupId() + "']." + invocation + ";\n";
    }

    public void fitMarkers(List<GLatLng> markersToShow) {
        this.fitMarkers(markersToShow, false, 0.0);
    }

    public void fitMarkers(List<GLatLng> markersToShow, boolean showMarkersForPoints) {
        this.fitMarkers(markersToShow, showMarkersForPoints, 0.0);
    }

    public void fitMarkers(final List<GLatLng> markersToShow, boolean showMarkersForPoints, final double zoomAdjustment) {
        if (markersToShow.isEmpty()) {
            log.warn("Empty list provided to GMap2.fitMarkers method.");
            return;
        }
        this.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                StringBuffer buf = new StringBuffer();
                buf.append("var bounds = new GLatLngBounds();\n");
                buf.append("var map = " + GMap2.this.getJSinvoke("map"));
                for (GLatLng point : markersToShow) {
                    buf.append("bounds.extend( " + point.getJSconstructor() + " );\n");
                }
                buf.append("map.setZoom( map.getBoundsZoomLevel(bounds) + " + zoomAdjustment + ");\n");
                buf.append("map.setCenter( bounds.getCenter() );\n");
                response.renderOnDomReadyJavaScript(buf.toString());
            }
        }});
        if (showMarkersForPoints) {
            for (GLatLng location : markersToShow) {
                this.addOverlay(new GMarker(location));
            }
        }
    }

    private String getJSsetGoogleBarEnabled(boolean enabled) {
        return this.getJSinvoke("setGoogleBarEnabled(" + enabled + ")");
    }

    private String getJSsetDraggingEnabled(boolean enabled) {
        return this.getJSinvoke("setDraggingEnabled(" + enabled + ")");
    }

    private String getJSsetDoubleClickZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setDoubleClickZoomEnabled(" + enabled + ")");
    }

    private String getJSsetScrollWheelZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setScrollWheelZoomEnabled(" + enabled + ")");
    }

    private String getJSsetZoom(int zoom) {
        return this.getJSinvoke("setZoom(" + zoom + ")");
    }

    private String getJSsetCenter(GLatLng center) {
        if (center != null) {
            return this.getJSinvoke("setCenter(" + center.getJSconstructor() + ")");
        }
        return "";
    }

    private String getJSpanDirection(int dx, int dy) {
        return this.getJSinvoke("panDirection(" + dx + "," + dy + ")");
    }

    private String getJSpanTo(GLatLng center) {
        return this.getJSinvoke("panTo(" + center.getJSconstructor() + ")");
    }

    private String getJSzoomOut() {
        return this.getJSinvoke("zoomOut()");
    }

    private String getJSzoomIn() {
        return this.getJSinvoke("zoomIn()");
    }

    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        this.bounds = GLatLngBounds.parse(request.getRequestParameters().getParameterValue("bounds").toString());
        this.center = GLatLng.parse(request.getRequestParameters().getParameterValue("center").toString());
        this.zoom = request.getRequestParameters().getParameterValue("zoom").toInt();
        this.mapType = GMapType.valueOf(request.getRequestParameters().getParameterValue("currentMapType").toString());
        this.infoWindow.update(target);
    }

    public void setOverlays(List<GOverlay> overlays) {
        this.removeAllOverlays();
        for (GOverlay overlay : overlays) {
            this.addOverlay(overlay);
        }
    }

    public class OverlayListener
    extends AbstractDefaultAjaxBehavior {
        private static final long serialVersionUID = 1L;

        protected void respond(AjaxRequestTarget target) {
            Request request = RequestCycle.get().getRequest();
            String overlayId = request.getRequestParameters().getParameterValue("overlay.overlayId").toString();
            String event = request.getRequestParameters().getParameterValue("overlay.event").toString();
            for (GOverlay overlay : GMap2.this.overlays) {
                if (!overlay.getId().equals(overlayId)) continue;
                overlay.onEvent(target, GEvent.valueOf(event));
                break;
            }
        }

        public Object getJSinit() {
            return GMap2.this.getJSinvoke("overlayListenerCallbackUrl = '" + this.getCallbackUrl() + "'");
        }
    }

    public class SetMapTypeBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final GMapType mapType;

        public SetMapTypeBehavior(String event, GMapType mapType) {
            super(event);
            this.mapType = mapType;
        }

        protected String getJSinvoke() {
            return this.mapType.getJSsetMapType(GMap2.this);
        }
    }

    public class SetCenterBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final GLatLng gLatLng;

        public SetCenterBehavior(String event, GLatLng gLatLng) {
            super(event);
            this.gLatLng = gLatLng;
        }

        protected String getJSinvoke() {
            return GMap2.this.getJSsetCenter(this.gLatLng);
        }
    }

    public class SetZoomBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final int zoom;

        public SetZoomBehavior(String event, int zoom) {
            super(event);
            this.zoom = zoom;
        }

        protected String getJSinvoke() {
            return GMap2.this.getJSsetZoom(this.zoom);
        }
    }

    public class PanDirectionBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private final int dx;
        private final int dy;

        public PanDirectionBehavior(String event, int dx, int dy) {
            super(event);
            this.dx = dx;
            this.dy = dy;
        }

        protected String getJSinvoke() {
            return GMap2.this.getJSpanDirection(this.dx, this.dy);
        }
    }

    public class ZoomInBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomInBehavior(String event) {
            super(event);
        }

        protected String getJSinvoke() {
            return GMap2.this.getJSzoomIn();
        }
    }

    public class ZoomOutBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomOutBehavior(String event) {
            super(event);
        }

        protected String getJSinvoke() {
            return GMap2.this.getJSzoomOut();
        }
    }

    private abstract class JSMethodBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final String attribute;

        public JSMethodBehavior(String attribute) {
            this.attribute = attribute;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            String invoke = this.getJSinvoke();
            if (this.attribute.equalsIgnoreCase("href")) {
                invoke = "javascript:" + invoke;
            }
            tag.put(this.attribute, (CharSequence)invoke);
        }

        protected abstract String getJSinvoke();
    }
}

