/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.WicketAjaxReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import wicket.contrib.gmap.GMap2;

public class GMapHeaderContributor
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String GMAP_API_URL = "http://www.google.com/jsapi?key=";
    private static final ResourceReference WICKET_GMAP_JS = new JavaScriptResourceReference(GMap2.class, "wicket-gmap.js");
    protected static final String GOOGLE_LOAD_MAPS = "google.load(\"maps\", \"2.x\");";
    private final String gMapKey;

    public GMapHeaderContributor(String gMapKey) {
        this.gMapKey = gMapKey;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        response.renderJavaScriptReference(GMAP_API_URL + this.gMapKey);
        response.renderJavaScript((CharSequence)GOOGLE_LOAD_MAPS, GMapHeaderContributor.class.getName() + "_googleload");
        response.renderJavaScriptReference(WicketEventReference.INSTANCE);
        response.renderJavaScriptReference(WicketAjaxReference.INSTANCE);
        response.renderJavaScriptReference(WICKET_GMAP_JS);
        response.renderOnEventJavaScript("window", "onUnload", "google.maps.Unload();");
    }
}

