/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import wicket.contrib.gmap.GMapHeaderContributor;
import wicket.contrib.gmap.api.GLatLng;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GClientGeocoder
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private TextField<?> addressField;
    private GMapHeaderContributor headerContrib;

    public GClientGeocoder(String event, TextField<?> addressField, String key) {
        super(event);
        this.addressField = addressField;
        this.addressField.setOutputMarkupId(true);
        this.headerContrib = new GMapHeaderContributor(key);
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        this.headerContrib.renderHead(c, response);
    }

    protected void onEvent(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        IRequestParameters parameters = request.getRequestParameters();
        this.onGeoCode(target, parameters.getParameterValue("status").toInt(), parameters.getParameterValue("address").toString(), GLatLng.parse(parameters.getParameterValue("point").toString()));
    }

    public abstract void onGeoCode(AjaxRequestTarget var1, int var2, String var3, GLatLng var4);

    protected CharSequence generateCallbackScript(CharSequence partialCall) {
        return "Wicket.geocoder.getLatLng('" + this.getCallbackUrl() + "', '" + this.addressField.getMarkupId() + "');" + "return false;";
    }
}

