/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import java.util.Iterator;
import java.util.List;
import wicket.contrib.gmap.api.GPoint;
import wicket.contrib.gmap.api.GSize;
import wicket.contrib.gmap.api.GValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GIcon
implements GValue,
Cloneable {
    private static final long serialVersionUID = 1714038753187423501L;
    private String image = "http://www.google.com/mapfiles/marker.png";
    private String shadow = "http://www.google.com/mapfiles/shadow50.png";
    private GSize iconSize = null;
    private GSize shadowSize = null;
    private GPoint iconAnchor = null;
    private GPoint infoWindowAnchor = null;
    private GPoint infoShadowAnchor = null;
    private List<Integer> imageMap = null;

    public GIcon() {
    }

    public GIcon(String image) {
        this.image = image;
    }

    public GIcon(String image, String shadow) {
        this.image = image;
        this.shadow = shadow;
    }

    public GIcon(String image, String shadow, GSize iconSize, GSize shadowSize, GPoint iconAnchor, GPoint infoWindowAnchor, GPoint infoShadowAnchor) {
        this.image = image;
        this.shadow = shadow;
        this.iconSize = iconSize;
        this.shadowSize = shadowSize;
        this.iconAnchor = iconAnchor;
        this.infoWindowAnchor = infoWindowAnchor;
        this.infoShadowAnchor = infoShadowAnchor;
    }

    public GIcon clone() {
        try {
            return (GIcon)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GIcon other = (GIcon)obj;
        if (this.iconAnchor == null ? other.iconAnchor != null : !this.iconAnchor.equals(other.iconAnchor)) {
            return false;
        }
        if (this.iconSize == null ? other.iconSize != null : !this.iconSize.equals(other.iconSize)) {
            return false;
        }
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.imageMap == null ? other.imageMap != null : !((Object)this.imageMap).equals(other.imageMap)) {
            return false;
        }
        if (this.infoShadowAnchor == null ? other.infoShadowAnchor != null : !this.infoShadowAnchor.equals(other.infoShadowAnchor)) {
            return false;
        }
        if (this.infoWindowAnchor == null ? other.infoWindowAnchor != null : !this.infoWindowAnchor.equals(other.infoWindowAnchor)) {
            return false;
        }
        if (this.shadow == null ? other.shadow != null : !this.shadow.equals(other.shadow)) {
            return false;
        }
        return !(this.shadowSize == null ? other.shadowSize != null : !this.shadowSize.equals(other.shadowSize));
    }

    public GPoint getIconAnchor() {
        return this.iconAnchor;
    }

    public GSize getIconSize() {
        return this.iconSize;
    }

    public String getId() {
        return "icon" + String.valueOf(System.identityHashCode(this));
    }

    public String getImage() {
        return this.image;
    }

    public List<Integer> getImageMap() {
        return this.imageMap;
    }

    public GPoint getInfoShadowAnchor() {
        return this.infoShadowAnchor;
    }

    public GPoint getInfoWindowAnchor() {
        return this.infoWindowAnchor;
    }

    @Override
    public String getJSconstructor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(function() {\n");
        buffer.append("var icon = new GIcon(G_DEFAULT_ICON);\n");
        buffer.append("icon.image = \"").append(this.image).append("\";\n");
        buffer.append("icon.shadow = \"").append(this.shadow).append("\";\n");
        if (this.iconSize != null) {
            buffer.append("icon.iconSize = ").append(this.iconSize.getJSconstructor()).append(";\n");
        }
        if (this.shadowSize != null) {
            buffer.append("icon.shadowSize = ").append(this.shadowSize.getJSconstructor()).append(";\n");
        }
        if (this.imageMap != null) {
            buffer.append("icon.imageMap  = [");
            Iterator<Integer> imit = this.imageMap.iterator();
            while (imit.hasNext()) {
                buffer.append(imit.next().toString());
                if (!imit.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("];\n");
        }
        if (this.iconAnchor != null) {
            buffer.append("icon.iconAnchor = ").append(this.iconAnchor.getJSconstructor()).append(";\n");
        }
        if (this.infoWindowAnchor != null) {
            buffer.append("icon.infoWindowAnchor = ").append(this.infoWindowAnchor.getJSconstructor()).append(";\n");
        }
        if (this.infoShadowAnchor != null) {
            buffer.append("icon.infoShadowAnchor = ").append(this.infoShadowAnchor.getJSconstructor()).append(";\n");
        }
        buffer.append("return icon;\n");
        buffer.append("})()\n");
        return buffer.toString();
    }

    public String getShadow() {
        return this.shadow;
    }

    public GSize getShadowSize() {
        return this.shadowSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iconAnchor == null ? 0 : this.iconAnchor.hashCode());
        result = 31 * result + (this.iconSize == null ? 0 : this.iconSize.hashCode());
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.imageMap == null ? 0 : ((Object)this.imageMap).hashCode());
        result = 31 * result + (this.infoShadowAnchor == null ? 0 : this.infoShadowAnchor.hashCode());
        result = 31 * result + (this.infoWindowAnchor == null ? 0 : this.infoWindowAnchor.hashCode());
        result = 31 * result + (this.shadow == null ? 0 : this.shadow.hashCode());
        result = 31 * result + (this.shadowSize == null ? 0 : this.shadowSize.hashCode());
        return result;
    }

    public GIcon iconAnchor(GPoint iconAnchor) {
        GIcon clone = this.clone();
        clone.iconAnchor = iconAnchor;
        return clone;
    }

    public GIcon iconSize(GSize iconSize) {
        GIcon clone = this.clone();
        clone.iconSize = iconSize;
        return clone;
    }

    public GIcon infoShadowAnchor(GPoint infoShadowAnchor) {
        GIcon clone = this.clone();
        clone.infoShadowAnchor = infoShadowAnchor;
        return clone;
    }

    public GIcon infoWindowAnchor(GPoint infoWindowAnchor) {
        GIcon clone = this.clone();
        clone.infoWindowAnchor = infoWindowAnchor;
        return clone;
    }

    public void setIconAnchor(GPoint iconAnchor) {
        this.iconAnchor = iconAnchor;
    }

    public void setIconSize(GSize iconSize) {
        this.iconSize = iconSize;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setImageMap(List<Integer> imageMap) {
        this.imageMap = imageMap;
    }

    public void setInfoShadowAnchor(GPoint infoShadowAnchor) {
        this.infoShadowAnchor = infoShadowAnchor;
    }

    public void setInfoWindowAnchor(GPoint infoWindowAnchor) {
        this.infoWindowAnchor = infoWindowAnchor;
    }

    public void setShadow(String shadow) {
        this.shadow = shadow;
    }

    public void setShadowSize(GSize shadowSize) {
        this.shadowSize = shadowSize;
    }

    public GIcon shadowSize(GSize shadowSize) {
        GIcon clone = this.clone();
        clone.shadowSize = shadowSize;
        return clone;
    }
}

