/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import wicket.contrib.gmap.GMap2;
import wicket.contrib.gmap.api.GInfoWindowTab;
import wicket.contrib.gmap.api.GLatLng;
import wicket.contrib.gmap.api.GMarker;

public class GInfoWindow
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private GInfoWindowTab[] tabs;
    private GLatLng latLng;
    private GMarker marker;
    private RepeatingView content = new RepeatingView("content");

    public GInfoWindow() {
        super("infoWindow");
        this.setOutputMarkupId(true);
        this.add(new Component[]{this.content});
    }

    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        if (request.getRequestParameters().getParameterValue("infoWindow.hidden").toBoolean()) {
            this.setTabs(new GInfoWindowTab[0]);
            this.marker = null;
            this.latLng = null;
        }
    }

    public final String getJSinit() {
        if (this.latLng != null) {
            return this.getJSopen(this.latLng, this.tabs);
        }
        if (this.marker != null) {
            return this.getJSopen(this.marker, this.tabs);
        }
        return "";
    }

    private void setTabs(GInfoWindowTab[] tabs) {
        this.content.removeAll();
        this.tabs = tabs;
        for (GInfoWindowTab tab : tabs) {
            this.content.add(new Component[]{tab.getContent()});
        }
    }

    public GInfoWindow open(GLatLng latLng, Component content) {
        return this.open(latLng, new GInfoWindowTab(content));
    }

    public GInfoWindow open(GMarker marker, Component content) {
        return this.open(marker, new GInfoWindowTab(content));
    }

    public GInfoWindow open(GLatLng latLng, GInfoWindowTab ... tabs) {
        this.setTabs(tabs);
        this.latLng = latLng;
        this.marker = null;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSopen(latLng, tabs));
            AjaxRequestTarget.get().add(new Component[]{this});
        }
        return this;
    }

    public GInfoWindow open(GMarker marker, GInfoWindowTab ... tabs) {
        this.setTabs(tabs);
        this.latLng = null;
        this.marker = marker;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSopen(marker, tabs));
            AjaxRequestTarget.get().add(new Component[]{this});
        }
        return this;
    }

    public boolean isOpen() {
        return this.latLng != null || this.marker != null;
    }

    public void close() {
        this.setTabs(new GInfoWindowTab[0]);
        this.marker = null;
        this.latLng = null;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)this.getJSclose());
            AjaxRequestTarget.get().add(new Component[]{this});
        }
    }

    private String getJSopen(GLatLng latLng, GInfoWindowTab[] tabs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openInfoWindowTabs(");
        buffer.append(latLng.getJSconstructor());
        buffer.append(",[");
        boolean first = true;
        for (GInfoWindowTab tab : tabs) {
            if (!first) {
                buffer.append(",");
            }
            buffer.append(tab.getJSconstructor());
            first = false;
        }
        buffer.append("])");
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSopen(GMarker marker, GInfoWindowTab[] tabs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("openMarkerInfoWindowTabs('");
        buffer.append(marker.getId());
        buffer.append("',[");
        boolean first = true;
        for (GInfoWindowTab tab : tabs) {
            if (!first) {
                buffer.append(",");
            }
            buffer.append(tab.getJSconstructor());
            first = false;
        }
        buffer.append("])");
        return this.getGMap2().getJSinvoke(buffer.toString());
    }

    private String getJSclose() {
        return this.getGMap2().getJSinvoke("closeInfoWindow()");
    }

    private GMap2 getGMap2() {
        return (GMap2)this.findParent(GMap2.class);
    }
}

