/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import java.util.StringTokenizer;
import wicket.contrib.gmap.api.GValue;
import wicket.contrib.gmap.js.Constructor;

public class GLatLng
implements GValue {
    private static final long serialVersionUID = 1L;
    private final double lat;
    private final double lng;
    private final boolean unbounded;

    public GLatLng(double lat, double lng) {
        this(lat, lng, false);
    }

    public GLatLng(double lat, double lng, boolean unbounded) {
        this.lat = lat;
        this.lng = lng;
        this.unbounded = unbounded;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public String toString() {
        return this.getJSconstructor();
    }

    public String getJSconstructor() {
        return new Constructor("GLatLng").add(this.lat).add(this.lng).add(this.unbounded).toJS();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lng);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unbounded ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GLatLng other = (GLatLng)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lng) != Double.doubleToLongBits(other.lng)) {
            return false;
        }
        return this.unbounded == other.unbounded;
    }

    public static GLatLng parse(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lat = Float.valueOf(tokenizer.nextToken()).floatValue();
            float lng = Float.valueOf(tokenizer.nextToken()).floatValue();
            return new GLatLng(lat, lng);
        }
        catch (Exception e) {
            return null;
        }
    }
}

