/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import wicket.contrib.gmap.api.GIcon;
import wicket.contrib.gmap.api.GValue;
import wicket.contrib.gmap.js.ObjectLiteral;

public class GMarkerOptions
implements GValue,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String title;
    private boolean clickable = true;
    private boolean draggable = false;
    private boolean bouncy = true;
    private boolean autoPan = false;
    private GIcon icon = null;

    public GMarkerOptions() {
    }

    public GMarkerOptions(String title) {
        this.title = title;
    }

    public GMarkerOptions(String title, GIcon icon) {
        this.title = title;
        this.icon = icon;
    }

    public String getJSconstructor() {
        ObjectLiteral literal = new ObjectLiteral();
        if (this.title != null) {
            literal.setString("title", this.title);
        }
        if (!this.clickable) {
            literal.set("clickable", "false");
        }
        if (this.draggable) {
            literal.set("draggable", "true");
        }
        if (!this.bouncy) {
            literal.set("bouncy", "false");
        }
        if (this.autoPan) {
            literal.set("autoPan", "true");
        }
        if (this.icon != null) {
            literal.set("icon", this.icon.getJSconstructor());
        }
        return literal.toJS();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public boolean isBouncy() {
        return this.bouncy;
    }

    public boolean isAutoPan() {
        return this.autoPan;
    }

    public GIcon getIcon() {
        return this.icon;
    }

    public GMarkerOptions clone() {
        try {
            return (GMarkerOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public GMarkerOptions clickable(boolean clickable) {
        GMarkerOptions clone = this.clone();
        clone.clickable = clickable;
        return clone;
    }

    public GMarkerOptions draggable(boolean draggable) {
        GMarkerOptions clone = this.clone();
        clone.draggable = draggable;
        return clone;
    }

    public GMarkerOptions autoPan(boolean autoPan) {
        GMarkerOptions clone = this.clone();
        clone.autoPan = autoPan;
        return clone;
    }

    public GMarkerOptions bouncy(boolean bouncy) {
        GMarkerOptions clone = this.clone();
        clone.bouncy = bouncy;
        return clone;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.autoPan ? 1231 : 1237);
        result = 31 * result + (this.bouncy ? 1231 : 1237);
        result = 31 * result + (this.clickable ? 1231 : 1237);
        result = 31 * result + (this.draggable ? 1231 : 1237);
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMarkerOptions other = (GMarkerOptions)obj;
        if (this.autoPan != other.autoPan) {
            return false;
        }
        if (this.bouncy != other.bouncy) {
            return false;
        }
        if (this.clickable != other.clickable) {
            return false;
        }
        if (this.draggable != other.draggable) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

