/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import wicket.contrib.gmap.GMap2;
import wicket.contrib.gmap.api.GEvent;
import wicket.contrib.gmap.api.GEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GOverlay
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private GMap2 parent = null;
    private final Map<GEvent, GEventHandler> events = new EnumMap<GEvent, GEventHandler>(GEvent.class);

    public GOverlay() {
        this.id = String.valueOf(Session.get().nextSequenceValue());
    }

    public String getJSadd() {
        StringBuffer js = new StringBuffer(this.parent.getJSinvoke("addOverlay('" + this.getId() + "', " + this.getJSconstructor() + ")"));
        for (GEvent event : this.events.keySet()) {
            js.append(event.getJSadd(this));
        }
        return js.toString();
    }

    public String getJSremove() {
        StringBuffer js = new StringBuffer();
        for (GEvent event : this.events.keySet()) {
            js.append(event.getJSclear(this));
        }
        js.append(this.parent.getJSinvoke("removeOverlay('" + this.getId() + "')"));
        return js.toString();
    }

    public String getId() {
        return this.id;
    }

    public abstract String getJSconstructor();

    public GMap2 getParent() {
        return this.parent;
    }

    public void setParent(GMap2 parent) {
        this.parent = parent;
    }

    public GOverlay addListener(GEvent event, GEventHandler handler) {
        this.events.put(event, handler);
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)event.getJSadd(this));
        }
        return this;
    }

    public Map<GEvent, GEventHandler> getListeners() {
        return Collections.unmodifiableMap(this.events);
    }

    public GOverlay clearListeners(GEvent event) {
        this.events.remove(event);
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavaScript((CharSequence)event.getJSclear(this));
        }
        return this;
    }

    public void onEvent(AjaxRequestTarget target, GEvent overlayEvent) {
        this.updateOnAjaxCall(target, overlayEvent);
        this.events.get(overlayEvent).onEvent(target);
    }

    protected abstract void updateOnAjaxCall(AjaxRequestTarget var1, GEvent var2);
}

