/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.gmap.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.apache.wicket.util.io.IOUtils;
import wicket.contrib.gmap.api.GLatLng;
import wicket.contrib.gmap.util.GeocoderException;

public class Geocoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OUTPUT_CSV = "csv";
    public static final String OUTPUT_XML = "xml";
    public static final String OUTPUT_KML = "kml";
    public static final String OUTPUT_JSON = "json";
    private final String gMapKey;

    public Geocoder(String gMapKey) {
        if (gMapKey == null) {
            throw new IllegalArgumentException("API key cannot be null");
        }
        this.gMapKey = gMapKey;
    }

    public GLatLng decode(String response) throws GeocoderException {
        StringTokenizer gLatLng = new StringTokenizer(response, ",");
        String status = gLatLng.nextToken();
        gLatLng.nextToken();
        String latitude = gLatLng.nextToken();
        String longitude = gLatLng.nextToken();
        if (Integer.parseInt(status) != 200) {
            throw new GeocoderException(Integer.parseInt(status));
        }
        return new GLatLng(Double.parseDouble(latitude), Double.parseDouble(longitude));
    }

    public String encode(String address) {
        return "http://maps.google.com/maps/geo?q=" + this.urlEncode(address) + "&output=" + OUTPUT_CSV + "&key=" + this.gMapKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLatLng geocode(String address) throws IOException {
        InputStream is = this.invokeService(this.encode(address));
        if (is != null) {
            try {
                String content = IOUtils.toString((InputStream)is);
                GLatLng gLatLng = this.decode(content);
                return gLatLng;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    protected InputStream invokeService(String address) throws IOException {
        URL url = new URL(address);
        return url.openStream();
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

