/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GOverlay;
import org.wicketstuff.gmap.js.ObjectLiteral;

public class GCircle
extends GOverlay {
    private static final long serialVersionUID = 1L;
    private final GLatLng center;
    private final double radius;
    private final String strokeColor;
    private final int strokeWeight;
    private final float strokeOpacity;
    private final String fillColor;
    private final float fillOpacity;
    private boolean clickable = true;
    private boolean draggable;
    private boolean editable;
    private boolean visible = true;
    private Integer zIndex;

    public GCircle(GLatLng center, double radius, String strokeColor, int strokeWeight, float strokeOpacity, String fillColor, float fillOpacity) {
        this.center = (GLatLng)Args.notNull((Object)center, (String)"center");
        Checks.withinRangeShort((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(Double.MAX_VALUE), (Comparable)Double.valueOf(radius), (String)"radius");
        this.radius = radius;
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.strokeOpacity = strokeOpacity;
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
    }

    @Override
    public String getJSconstructor() {
        return "new google.maps.Circle(" + this.getSettings().toJS() + ")";
    }

    private ObjectLiteral getSettings() {
        ObjectLiteral settings = new ObjectLiteral();
        settings.set("strokeWeight", String.valueOf(this.strokeWeight));
        settings.setString("strokeColor", this.strokeColor);
        settings.set("strokeOpacity", String.valueOf(this.strokeOpacity));
        settings.setString("fillColor", this.fillColor);
        settings.set("fillOpacity", String.valueOf(this.fillOpacity));
        settings.set("center", this.center.toString());
        settings.set("radius", String.valueOf(this.radius));
        if (!this.clickable) {
            settings.set("clickable", "false");
        }
        if (this.draggable) {
            settings.set("draggable", "true");
        }
        if (this.editable) {
            settings.set("editable", "true");
        }
        if (!this.visible) {
            settings.set("visible", "false");
        }
        if (this.zIndex != null) {
            settings.set("zIndex", String.valueOf(this.zIndex));
        }
        return settings;
    }

    @Override
    protected void updateOnAjaxCall(AjaxRequestTarget target, GEvent overlayEvent) {
    }

    public GCircle setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public GCircle setDraggable(boolean draggable) {
        this.draggable = draggable;
        return this;
    }

    public GCircle setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public GCircle setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GCircle setZIndex(Integer zIndex) {
        if (zIndex != null) {
            Checks.withinRangeShort((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE), (Comparable)zIndex, (String)"zIndex");
        }
        this.zIndex = zIndex;
        return this;
    }
}

