/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.event;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.StringValueConversionException;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.event.GEventListenerBehavior;

public abstract class DblClickListener
extends GEventListenerBehavior {
    private static final long serialVersionUID = -6193218322346599432L;

    @Override
    protected String getEvent() {
        return "dblclick";
    }

    @Override
    protected final void onEvent(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        NumberFormat fmt = DecimalFormat.getInstance(Locale.US);
        GLatLng latLng = null;
        String latStr = request.getRequestParameters().getParameterValue("lat").toString();
        String lngStr = request.getRequestParameters().getParameterValue("lng").toString();
        Double lat = null;
        Double lng = null;
        try {
            lat = fmt.parse(latStr).doubleValue();
            lng = fmt.parse(lngStr).doubleValue();
        }
        catch (ParseException e) {
            throw new StringValueConversionException("Unable to convert 'lat/lng' to a double value", (Throwable)e);
        }
        latLng = new GLatLng(lat, lng);
        this.onDblClick(target, latLng);
    }

    protected abstract void onDblClick(AjaxRequestTarget var1, GLatLng var2);
}

