/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.gmap.WicketGMapJsReference;

public class GMapHeaderContributor
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String GMAP_API_URL = "%s://maps.googleapis.com/maps/api/js?v=3&";
    private static final String HTTP = "http";
    private String scheme;
    private String sensor = "false";
    private String apiKey = null;

    public GMapHeaderContributor(String scheme, String apiKey) {
        this.scheme = scheme;
        this.apiKey = apiKey;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WicketGMapJsReference.INSTANCE));
        Object url = String.format(GMAP_API_URL, this.scheme);
        if (this.apiKey != null) {
            url = (String)url + "key=" + this.apiKey;
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)url));
    }
}

