/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import java.util.Optional;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketstuff.gmap.api.GAnimation;
import org.wicketstuff.gmap.api.GEvent;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GMarkerOptions;
import org.wicketstuff.gmap.api.GOverlay;
import org.wicketstuff.gmap.js.Constructor;

public class GMarker
extends GOverlay {
    private static final long serialVersionUID = 1L;
    private final GMarkerOptions options;

    public GMarker(GMarkerOptions options) {
        this.options = options;
    }

    public GMarker(String id, GMarkerOptions options) {
        super(id);
        this.options = options;
    }

    public GLatLng getLatLng() {
        return this.options.getLatLng();
    }

    public GMarkerOptions getMarkerOptions() {
        return this.options;
    }

    public void setAnimation(GAnimation animation) {
        Optional targetOptional = ThreadContext.getRequestCycle().find(AjaxRequestTarget.class);
        targetOptional.ifPresent(target -> {
            this.options.setAnimation(animation);
            String animationToSet = null;
            if (animation != null) {
                animationToSet = animation.toString();
            }
            target.appendJavaScript((CharSequence)(this.getParent().getJsReference() + ".overlays['overlay" + this.getId() + "'].setAnimation(" + animationToSet + ")"));
        });
    }

    @Override
    public String getJSconstructor() {
        Constructor constructor = new Constructor("google.maps.Marker").add(this.options.getJSconstructor());
        return constructor.toJS();
    }

    @Override
    protected void updateOnAjaxCall(AjaxRequestTarget target, GEvent overlayEvent) {
        Request request = RequestCycle.get().getRequest();
        this.options.setLatLng(GLatLng.parse(request.getRequestParameters().getParameterValue("overlay.latLng").toString()));
    }
}

