/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.geocoder;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.gmap.GMap;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GLatLngBounds;
import org.wicketstuff.gmap.geocoder.GeocoderException;
import org.wicketstuff.gmap.geocoder.GeocoderStatus;
import org.wicketstuff.gmap.geocoder.pojos.GeocoderResult;
import org.wicketstuff.gmap.geocoder.pojos.NortheastSoutwestInfo;

public class Geocoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Geocoder.class);
    public static final String OUTPUT_XML = "xml";
    public static final String OUTPUT_JSON = "json";
    private final String output = "json";
    private GeocoderResult geocoderResult;
    private ObjectMapper objectMapper;
    private String apiKey = null;

    public Geocoder(String apiKey) {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.apiKey = apiKey;
    }

    public Geocoder(ObjectMapper mapper, String apiKey) {
        this.objectMapper = mapper;
        this.apiKey = apiKey;
    }

    public GLatLng decode(String response) throws GeocoderException, JSONException {
        try {
            this.geocoderResult = (GeocoderResult)this.objectMapper.readValue(response, GeocoderResult.class);
        }
        catch (JsonParseException jpe) {
            LOGGER.error("Geocoder JSON parsing failed", (Throwable)jpe);
        }
        catch (JsonMappingException jme) {
            LOGGER.error("Something went wrong during json mapping. Check your ObjectMapper when customize.", (Throwable)jme);
        }
        catch (IOException ioe) {
            LOGGER.error("Upps. Panic!", (Throwable)ioe);
        }
        GeocoderStatus status = this.geocoderResult.getStatus();
        if (status != GeocoderStatus.OK) {
            throw new GeocoderException(status);
        }
        if (this.geocoderResult.getResults().length < 1) {
            throw new IllegalStateException("GecoderStatus return GeocoderStatus.OK but size of the results was less then 1");
        }
        return this.geocoderResult.getResults()[0].getGeometry().getLocation();
    }

    public String encode(String address) {
        StringBuilder sb = new StringBuilder("https://maps.googleapis.com/maps/api/geocode/");
        sb.append(OUTPUT_JSON);
        sb.append("?");
        if (this.apiKey != null) {
            sb.append("key=").append(this.apiKey).append("&");
        }
        sb.append("address=").append(this.urlEncode(address));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLatLng geocode(String address) throws IOException {
        InputStream is = this.invokeService(this.encode(address));
        if (is != null) {
            try {
                String content = IOUtils.toString((InputStream)is);
                GLatLng gLatLng = this.decode(content);
                return gLatLng;
            }
            finally {
                is.close();
            }
        }
        return null;
    }

    protected InputStream invokeService(String address) throws IOException {
        URL url = new URL(address);
        return url.openStream();
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public GeocoderResult getGecoderResult() {
        return this.geocoderResult;
    }

    public void centerAndFitZoomForAdress(GMap map, String address) throws Exception {
        this.geocode(address);
        NortheastSoutwestInfo port = this.getGecoderResult().getResults()[0].getGeometry().getViewport();
        GLatLng sw = new GLatLng(port.getSouthwest().getLat(), port.getSouthwest().getLng());
        GLatLng ne = new GLatLng(port.getNortheast().getLat(), port.getNortheast().getLng());
        map.setBounds(new GLatLngBounds(sw, ne));
    }
}

