/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.googlecharts;

public enum ChartDataEncoding {
    SIMPLE("s", "", ","){

        @Override
        CharSequence convert(double value, double max) {
            if (value < 0.0) {
                return "_";
            }
            value = Math.round((double)(ChartDataEncoding.CHARS.length() - 1) * value / max);
            if (value > (double)(ChartDataEncoding.CHARS.length() - 1)) {
                throw new IllegalArgumentException(value + " is out of range for SIMPLE encoding");
            }
            return Character.toString(ChartDataEncoding.CHARS.charAt((int)value));
        }
    }
    ,
    TEXT("t", ",", "|"){

        @Override
        CharSequence convert(double value, double max) {
            if (value < 0.0) {
                value = -1.0;
            }
            if (value > 100.0) {
                throw new IllegalArgumentException(value + " is out of range for TEXT encoding");
            }
            return Double.toString(value);
        }
    }
    ,
    EXTENDED("e", "", ","){

        @Override
        CharSequence convert(double value, double max) {
            if (value < 0.0) {
                return "__";
            }
            if ((value = (double)Math.round(value)) > (double)((ChartDataEncoding.EXT_CHARS.length() - 1) * (ChartDataEncoding.EXT_CHARS.length() - 1))) {
                throw new IllegalArgumentException(value + " is out of range for EXTENDED encoding");
            }
            int rem = (int)(value % (double)ChartDataEncoding.EXT_CHARS.length());
            int exp = (int)(value / (double)ChartDataEncoding.EXT_CHARS.length());
            return new StringBuilder().append(ChartDataEncoding.EXT_CHARS.charAt(exp)).append(ChartDataEncoding.EXT_CHARS.charAt(rem));
        }
    };

    private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String EXT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
    private final String rendering;
    private final String valueSeparator;
    private final String setSeparator;

    private ChartDataEncoding(String rendering, String valueSeparator, String setSeparator) {
        this.rendering = rendering;
        this.valueSeparator = valueSeparator;
        this.setSeparator = setSeparator;
    }

    public String getRendering() {
        return this.rendering;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public String getSetSeparator() {
        return this.setSeparator;
    }

    abstract CharSequence convert(double var1, double var3);
}

