/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.googlecharts;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.googlecharts.ChartType;
import org.wicketstuff.googlecharts.IChartAxis;
import org.wicketstuff.googlecharts.IChartData;
import org.wicketstuff.googlecharts.IChartFill;
import org.wicketstuff.googlecharts.IChartGrid;
import org.wicketstuff.googlecharts.IChartProvider;
import org.wicketstuff.googlecharts.IFillArea;
import org.wicketstuff.googlecharts.ILineStyle;
import org.wicketstuff.googlecharts.IRangeMarker;
import org.wicketstuff.googlecharts.IShapeMarker;
import org.wicketstuff.googlecharts.ITextValueMarker;

public class ChartProvider
implements IChartProvider {
    private static final long serialVersionUID = -2660199063331734673L;
    private List<IChartAxis> axes = new ArrayList<IChartAxis>();
    private IChartFill backgroundFill;
    private int barGroupSpacing = -1;
    private int barWidth = -1;
    private IChartFill chartFill;
    private Color[] colors;
    private List<IFillArea> fillAreas = new ArrayList<IFillArea>();
    private IChartGrid grid;
    private String[] legend;
    private ILineStyle[] lineStyles;
    private String[] pieLabels;
    private List<IRangeMarker> rangeMarkers = new ArrayList<IRangeMarker>();
    private List<IShapeMarker> shapeMarkers = new ArrayList<IShapeMarker>();
    private List<ITextValueMarker> textValueMarkers = new ArrayList<ITextValueMarker>();
    private Dimension size;
    private String title;
    private ChartType type;
    private IChartData data;

    public ChartProvider(Dimension size, ChartType type, IChartData data) {
        this.size = size;
        this.type = type;
        this.data = data;
    }

    @Override
    public IChartAxis[] getAxes() {
        return this.axes.toArray(new IChartAxis[this.axes.size()]);
    }

    @Override
    public IChartFill getBackgroundFill() {
        return this.backgroundFill;
    }

    @Override
    public int getBarGroupSpacing() {
        return this.barGroupSpacing;
    }

    @Override
    public int getBarWidth() {
        return this.barWidth;
    }

    @Override
    public IChartFill getChartFill() {
        return this.chartFill;
    }

    @Override
    public Color[] getColors() {
        return this.colors;
    }

    @Override
    public IFillArea[] getFillAreas() {
        return this.fillAreas.toArray(new IFillArea[this.fillAreas.size()]);
    }

    @Override
    public IChartGrid getGrid() {
        return this.grid;
    }

    @Override
    public String[] getLegend() {
        return this.legend;
    }

    @Override
    public ILineStyle[] getLineStyles() {
        return this.lineStyles;
    }

    @Override
    public String[] getPieLabels() {
        return this.pieLabels;
    }

    @Override
    public IRangeMarker[] getRangeMarkers() {
        return this.rangeMarkers.toArray(new IRangeMarker[this.rangeMarkers.size()]);
    }

    @Override
    public IShapeMarker[] getShapeMarkers() {
        return this.shapeMarkers.toArray(new IShapeMarker[this.shapeMarkers.size()]);
    }

    @Override
    public ITextValueMarker[] getTextValueMarkers() {
        return this.textValueMarkers.toArray(new ITextValueMarker[this.textValueMarkers.size()]);
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ChartType getType() {
        return this.type;
    }

    public void addFillArea(IFillArea fillArea) {
        this.fillAreas.add(fillArea);
    }

    public void addAxis(IChartAxis axis) {
        this.axes.add(axis);
    }

    public void setBackgroundFill(IChartFill backgroundFill) {
        this.backgroundFill = backgroundFill;
    }

    public void setBarGroupSpacing(int barGroupSpacing) {
        this.barGroupSpacing = barGroupSpacing;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public void setChartFill(IChartFill chartFill) {
        this.chartFill = chartFill;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setGrid(IChartGrid grid) {
        this.grid = grid;
    }

    public void setLegend(String[] legend) {
        this.legend = legend;
    }

    public void setLineStyles(ILineStyle[] lineStyles) {
        this.lineStyles = lineStyles;
    }

    public void setPieLabels(String[] pieLabels) {
        this.pieLabels = pieLabels;
    }

    public void addRangeMarker(IRangeMarker rangeMarker) {
        this.rangeMarkers.add(rangeMarker);
    }

    public void addShapeMarker(IShapeMarker shapeMarker) {
        this.shapeMarkers.add(shapeMarker);
    }

    public void addTextValueMarker(ITextValueMarker marker) {
        this.textValueMarkers.add(marker);
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    @Override
    public IChartData getData() {
        return this.data;
    }

    public void setData(IChartData data) {
        this.data = data;
    }
}

