/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.fileapi;

import java.util.Calendar;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.wicketstuff.html5.fileapi.FileList;
import org.wicketstuff.html5.fileapi.Html5File;

public abstract class FileFieldChangeBehavior
extends AjaxEventBehavior {
    private static final long serialVersionUID = -3716216245965207135L;
    protected static final ResourceReference JAVASCRIPT_REF = new JavaScriptResourceReference(FileFieldChangeBehavior.class, "fileapi.js");
    public static final int DEFAULT_MAX_NUM_OF_FILES = 100;
    private final int maxNumOfFiles;

    public FileFieldChangeBehavior() {
        this(100);
    }

    public FileFieldChangeBehavior(int maxNumOfFiles) {
        this("change", maxNumOfFiles);
    }

    protected FileFieldChangeBehavior(String event, int maxNumOfFiles) {
        super(event);
        this.maxNumOfFiles = maxNumOfFiles;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JAVASCRIPT_REF));
    }

    protected void onEvent(AjaxRequestTarget target) {
        IRequestParameters parameters = RequestCycle.get().getRequest().getPostParameters();
        int num = parameters.getParameterValue("num").toInt();
        if (num > this.maxNumOfFiles) {
            num = this.maxNumOfFiles;
        }
        FileList fileList = new FileList(num);
        for (int fi = 0; fi < num; ++fi) {
            Calendar lastModifiedDate;
            String prefix = "file[" + fi + "].";
            String name = parameters.getParameterValue(prefix + "name").toString();
            long size = parameters.getParameterValue(prefix + "size").toLong();
            String type = parameters.getParameterValue(prefix + "type").toString();
            StringValue lastModifiedTimeStr = parameters.getParameterValue(prefix + "lastModifiedTime");
            if (!lastModifiedTimeStr.isNull()) {
                long lastModifiedTime = lastModifiedTimeStr.toLong();
                lastModifiedDate = Calendar.getInstance();
                lastModifiedDate.setTimeInMillis(lastModifiedTime);
            } else {
                lastModifiedDate = null;
            }
            fileList.set(fi, new Html5File(name, size, type, lastModifiedDate));
        }
        this.onEvent(target, fileList);
    }

    protected abstract void onEvent(AjaxRequestTarget var1, FileList var2);

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setMethod(AjaxRequestAttributes.Method.POST);
        AjaxCallListener ajaxCallListener = new AjaxCallListener();
        ajaxCallListener.onPrecondition((CharSequence)("return Wicketstuff.fileapi.supports(this)&&Wicket.$('" + this.getComponent().getMarkupId() + "') != null;"));
        attributes.getDynamicExtraParameters().add("return Wicketstuff.fileapi.fileFieldToPostBody(Wicket.$(attrs.c));");
    }

    public int getMaxNumOfFiles() {
        return this.maxNumOfFiles;
    }
}

