/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.media.webrtc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.media.video.Video;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryResourceReference;

public abstract class WebRTC
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private Boolean debug;
    private Boolean volumeBars;
    private Integer framesPerSeconds;
    private Integer maxWidth;
    private Integer maxHeight;

    public WebRTC(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
    }

    public WebRTC(String id, IModel<?> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
    }

    public void renderHead(IHeaderResponse response) {
        try {
            Video localVideo = this.configureVideo();
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryResourceReference.get()));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(WebRTC.class, this.debug != null && this.debug != false ? "simplewebrtc.bundle.js" : "latest.js")));
            String initializejs = IOUtils.toString((InputStream)WebRTC.class.getResourceAsStream("WebRTC.js"));
            initializejs = initializejs.replaceAll("%\\(markupid\\)", this.getMarkupId());
            initializejs = initializejs.replaceAll("%\\(localvideoid\\)", localVideo.getMarkupId());
            initializejs = initializejs.replaceAll("%\\(roomname\\)", this.getRoomName());
            initializejs = initializejs.replaceAll("%\\(socketiourl\\)", this.getSocketIOUrl());
            initializejs = initializejs.replaceAll("%\\(volumebars\\)", this.getVolumeBars().toString());
            initializejs = initializejs.replaceAll("%\\(framesperseconds\\)", this.getFramesPerSeconds().toString());
            initializejs = initializejs.replaceAll("%\\(maxwidth\\)", this.getMaxWidth().toString());
            initializejs = initializejs.replaceAll("%\\(maxheight\\)", this.getMaxHeight().toString());
            initializejs = initializejs.replaceAll("%\\(poster\\)", RequestCycle.get().urlFor(this.getNoVideoResourceReference(), null).toString());
            initializejs = initializejs.replaceAll("%\\(errorurl\\)", (this.getErrorPage() != null ? RequestCycle.get().urlFor(this.getErrorPage(), null) : "").toString());
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forScript((CharSequence)initializejs, (String)(this.getMarkupId() + "script")));
            String css = IOUtils.toString((InputStream)WebRTC.class.getResourceAsStream("WebRTC.css"));
            css = css.replaceAll("%\\(maxwidth\\)", this.getMaxWidth().toString());
            css = css.replaceAll("%\\(maxheight\\)", this.getMaxHeight().toString());
            response.render((HeaderItem)CssReferenceHeaderItem.forCSS((CharSequence)css, (String)(this.getMarkupId() + "css")));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    private Video configureVideo() {
        Video localVideo = this.getLocalVideo();
        localVideo.setOutputMarkupId(true);
        localVideo.setPoster(this.getNoVideoResourceReference());
        return localVideo;
    }

    protected ResourceReference getNoVideoResourceReference() {
        return new PackageResourceReference(WebRTC.class, "novideo.gif");
    }

    public abstract Video getLocalVideo();

    public abstract String getRoomName();

    public abstract String getSocketIOUrl();

    public Boolean isDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Boolean getVolumeBars() {
        return this.volumeBars != null ? this.volumeBars : true;
    }

    public void setVolumeBars(Boolean volumeBars) {
        this.volumeBars = volumeBars;
    }

    public Integer getFramesPerSeconds() {
        return this.framesPerSeconds != null ? this.framesPerSeconds : 10;
    }

    public void setFramesPerSeconds(Integer framesPerSeconds) {
        this.framesPerSeconds = framesPerSeconds;
    }

    public Integer getMaxWidth() {
        return this.maxWidth != null ? this.maxWidth : 320;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Integer getMaxHeight() {
        return this.maxHeight != null ? this.maxHeight : 240;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public Class<? extends Page> getErrorPage() {
        return null;
    }
}

