/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.geolocation;

import java.util.HashMap;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.PackageTextTemplate;

public abstract class AjaxGeolocationBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static PackageTextTemplate GEOLOCATION_TMPL_JS = new PackageTextTemplate(AjaxGeolocationBehavior.class, "geolocation.js", "application/javascript", "UTF-8");
    private int timeoutInMilliseconds = 10000;

    protected void respond(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        String latitude = request.getRequestParameters().getParameterValue("lat").toString();
        String longitude = request.getRequestParameters().getParameterValue("long").toString();
        String errorCode = request.getRequestParameters().getParameterValue("code").toString();
        String errorMessage = request.getRequestParameters().getParameterValue("message").toString();
        String timeout = request.getRequestParameters().getParameterValue("timeout").toString();
        if (timeout != null) {
            this.onNotAvailable(target, "3", "Timeout after " + this.getTimeout() + " milliseconds");
        } else if (latitude == null || longitude == null) {
            this.onNotAvailable(target, errorCode, errorMessage);
        } else {
            this.onGeoAvailable(target, latitude, longitude);
        }
    }

    protected abstract void onGeoAvailable(AjaxRequestTarget var1, String var2, String var3);

    protected void onNotAvailable(AjaxRequestTarget target, String errorCode, String errorMessage) {
    }

    protected void onBind() {
        super.onBind();
        Component component = this.getComponent();
        component.setOutputMarkupId(true);
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        CharSequence callbackUrl = this.getCallbackUrl();
        String componentMarkupId = this.getComponent().getMarkupId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("componentId", componentMarkupId);
        variables.put("callbackUrl", callbackUrl.toString());
        variables.put("timeout", "" + this.timeoutInMilliseconds);
        String javascript = MapVariableInterpolator.interpolate((String)GEOLOCATION_TMPL_JS.asString(), variables);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)javascript));
    }

    public int getTimeout() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeout(int timeout) {
        this.timeoutInMilliseconds = timeout;
    }
}

