/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.image;

import java.io.DataInputStream;
import java.util.Base64;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.resource.IResourceStream;

public class InlineImage
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private PackageResourceReference packageResourceReference;

    public InlineImage(String id, PackageResourceReference packageResourceReference) {
        this(id, null, packageResourceReference);
    }

    public InlineImage(String id, IModel<?> model, PackageResourceReference packageResourceReference) {
        super(id, model);
        this.packageResourceReference = packageResourceReference;
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "img");
        super.onComponentTag(tag);
        IResourceStream packageResourceStream = this.packageResourceReference.getResource().getResourceStream();
        if (packageResourceStream != null) {
            try {
                StringBuilder builder = new StringBuilder();
                builder.append("data:");
                builder.append(packageResourceStream.getContentType());
                builder.append(";base64,");
                byte[] bytes = new byte[(int)packageResourceStream.length().bytes()];
                DataInputStream dataInputStream = new DataInputStream(packageResourceStream.getInputStream());
                dataInputStream.readFully(bytes);
                builder.append(Base64.getEncoder().encodeToString(bytes));
                tag.put("src", (CharSequence)builder.toString());
            }
            catch (Exception e) {
                throw new WicketRuntimeException("An error occured while reading the package resource stream", (Throwable)e);
            }
        } else {
            tag.put("src", (CharSequence)"#");
            tag.put("style", (CharSequence)"display:none;");
        }
    }
}

