/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.markup.html;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class Progress
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final IModel<? extends Number> max;
    private final IModel<? extends Number> current;

    public Progress(String id, IModel<? extends Number> current, IModel<? extends Number> max) {
        super(id);
        this.current = current;
        this.max = max;
    }

    public Progress(String id) {
        this(id, null, null);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "progress");
        if (this.isDeterminate()) {
            tag.put("value", (CharSequence)String.valueOf(this.getValue()));
            tag.put("max", (CharSequence)String.valueOf(this.getMax()));
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getBody());
    }

    protected CharSequence getBody() {
        if (this.isDeterminate()) {
            double currentValue = this.getValue().doubleValue();
            double maxValue = this.getMax().doubleValue();
            Double percentage = maxValue == 0.0 ? maxValue : currentValue / maxValue * 100.0;
            return percentage.intValue() + " %";
        }
        return "";
    }

    private Number getValue() {
        Number value = (Number)this.current.getObject();
        if (value == null || value.doubleValue() < 0.0) {
            value = 0.0;
        }
        Number max = this.getMax();
        if (value.doubleValue() > max.doubleValue()) {
            value = max;
        }
        return value;
    }

    private Number getMax() {
        Number maxValue = (Number)this.max.getObject();
        if (maxValue == null || maxValue.doubleValue() < 0.0) {
            maxValue = 0.0;
        }
        return maxValue;
    }

    public boolean isDeterminate() {
        return this.max != null && this.current != null;
    }
}

