/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.html5.media.webvtt;

import org.wicketstuff.html5.media.webvtt.VttRegion;
import org.wicketstuff.html5.media.webvtt.VttTime;

public class VttCue {
    private String cueId;
    private String line;
    private String position;
    private String size;
    private Alignment alignment;
    private Vertical vertical;
    private VttTime startTime;
    private VttTime stopTime;
    private String text;
    private String voiceSpan;
    private VttRegion vttRegion;
    private String note;

    public VttCue(String cueId, VttTime startTime, VttTime stopTime, String text) {
        this.cueId = cueId;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.text = text;
    }

    public String getLine() {
        return this.line;
    }

    public VttCue setLine(String line) {
        this.line = line;
        return this;
    }

    public String getPosition() {
        return this.position;
    }

    public VttCue setPosition(String position) {
        this.position = position;
        return this;
    }

    public String getSize() {
        return this.size;
    }

    public VttCue setSize(String size) {
        this.size = size;
        return this;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public VttCue setAlignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Vertical getVertical() {
        return this.vertical;
    }

    public VttCue setVertical(Vertical vertical) {
        this.vertical = vertical;
        return this;
    }

    public String getVoiceSpan() {
        return this.voiceSpan;
    }

    public VttCue setVoiceSpan(String voiceSpan) {
        this.voiceSpan = voiceSpan;
        return this;
    }

    public VttRegion getRegion() {
        return this.vttRegion;
    }

    public VttCue setRegion(VttRegion vttRegion) {
        this.vttRegion = vttRegion;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public VttCue setNote(String note) {
        this.note = note;
        return this;
    }

    public String getCueId() {
        return this.cueId;
    }

    public VttTime getStartTime() {
        return this.startTime;
    }

    public VttTime getStopTime() {
        return this.stopTime;
    }

    public String getText() {
        return this.text;
    }

    public StringBuilder getRepresentation() {
        StringBuilder builder = new StringBuilder(1000);
        builder.append(this.getCueId().replaceAll("\n", " "));
        builder.append("\n");
        builder.append(this.getStartTime().getRepresentation());
        builder.append(" --> ");
        builder.append(this.getStopTime().getRepresentation());
        if (this.getRegion() != null) {
            builder.append(" region:");
            builder.append(this.getRegion().getId());
        }
        if (this.getAlignment() != null) {
            builder.append(" align:");
            builder.append(this.getAlignment().name());
        }
        if (this.getVertical() != null) {
            builder.append(" vertical:");
            builder.append(this.getVertical().getVerticalName());
        }
        if (this.getSize() != null) {
            builder.append(" size:");
            builder.append(this.getSize());
        }
        if (this.getLine() != null) {
            builder.append(" line:");
            builder.append(this.getLine());
        }
        if (this.getPosition() != null) {
            builder.append(" position:");
            builder.append(this.getPosition());
        }
        builder.append("\n");
        if (this.getVoiceSpan() != null || this.getRegion() != null) {
            builder.append("<v");
            if (this.getVoiceSpan() != null) {
                builder.append(this.getVoiceSpan().startsWith(".") ? "" : " ");
                builder.append(this.getVoiceSpan());
            }
            if (this.getRegion() != null) {
                builder.append(" ");
                builder.append(this.getRegion().getId());
            }
            builder.append(">");
        }
        builder.append(this.getText());
        return builder;
    }

    public static enum Alignment {
        start,
        middle,
        end;

    }

    public static enum Vertical {
        lr("lr"),
        rl("rl");

        private String verticalName;

        private Vertical(String verticalName) {
            this.verticalName = verticalName;
        }

        public String getVerticalName() {
            return this.verticalName;
        }

        public void setVerticalName(String verticalName) {
            this.verticalName = verticalName;
        }
    }
}

